/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.drive;

import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.drive.RobotDriveBase;
import edu.wpi.first.wpilibj.drive.Vector2d;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class KilloughDrive
extends RobotDriveBase {
    public static final double kDefaultLeftMotorAngle = 60.0;
    public static final double kDefaultRightMotorAngle = 120.0;
    public static final double kDefaultBackMotorAngle = 270.0;
    private static int instances = 0;
    private SpeedController m_leftMotor;
    private SpeedController m_rightMotor;
    private SpeedController m_backMotor;
    private Vector2d m_leftVec;
    private Vector2d m_rightVec;
    private Vector2d m_backVec;
    private boolean m_reported = false;

    public KilloughDrive(SpeedController leftMotor, SpeedController rightMotor, SpeedController backMotor) {
        this(leftMotor, rightMotor, backMotor, 60.0, 120.0, 270.0);
    }

    public KilloughDrive(SpeedController leftMotor, SpeedController rightMotor, SpeedController backMotor, double leftMotorAngle, double rightMotorAngle, double backMotorAngle) {
        this.m_leftMotor = leftMotor;
        this.m_rightMotor = rightMotor;
        this.m_backMotor = backMotor;
        this.m_leftVec = new Vector2d(Math.cos(leftMotorAngle * (Math.PI / 180)), Math.sin(leftMotorAngle * (Math.PI / 180)));
        this.m_rightVec = new Vector2d(Math.cos(rightMotorAngle * (Math.PI / 180)), Math.sin(rightMotorAngle * (Math.PI / 180)));
        this.m_backVec = new Vector2d(Math.cos(backMotorAngle * (Math.PI / 180)), Math.sin(backMotorAngle * (Math.PI / 180)));
        this.addChild(this.m_leftMotor);
        this.addChild(this.m_rightMotor);
        this.addChild(this.m_backMotor);
        this.setName("KilloughDrive", ++instances);
    }

    public void driveCartesian(double ySpeed, double xSpeed, double zRotation) {
        this.driveCartesian(ySpeed, xSpeed, zRotation, 0.0);
    }

    public void driveCartesian(double ySpeed, double xSpeed, double zRotation, double gyroAngle) {
        if (!this.m_reported) {
            this.m_reported = true;
        }
        ySpeed = this.limit(ySpeed);
        ySpeed = this.applyDeadband(ySpeed, this.m_deadband);
        xSpeed = this.limit(xSpeed);
        xSpeed = this.applyDeadband(xSpeed, this.m_deadband);
        Vector2d input = new Vector2d(ySpeed, xSpeed);
        input.rotate(-gyroAngle);
        double[] wheelSpeeds = new double[3];
        wheelSpeeds[RobotDriveBase.MotorType.kLeft.value] = input.scalarProject(this.m_leftVec) + zRotation;
        wheelSpeeds[RobotDriveBase.MotorType.kRight.value] = input.scalarProject(this.m_rightVec) + zRotation;
        wheelSpeeds[RobotDriveBase.MotorType.kBack.value] = input.scalarProject(this.m_backVec) + zRotation;
        this.normalize(wheelSpeeds);
        this.m_leftMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kLeft.value] * this.m_maxOutput);
        this.m_rightMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kRight.value] * this.m_maxOutput);
        this.m_backMotor.set(wheelSpeeds[RobotDriveBase.MotorType.kBack.value] * this.m_maxOutput);
        this.m_safetyHelper.feed();
    }

    public void drivePolar(double magnitude, double angle, double zRotation) {
        if (!this.m_reported) {
            this.m_reported = true;
        }
        this.driveCartesian(magnitude * Math.sin(angle * (Math.PI / 180)), magnitude * Math.cos(angle * (Math.PI / 180)), zRotation, 0.0);
    }

    @Override
    public void stopMotor() {
        this.m_leftMotor.stopMotor();
        this.m_rightMotor.stopMotor();
        this.m_backMotor.stopMotor();
        this.m_safetyHelper.feed();
    }

    @Override
    public String getDescription() {
        return "KilloughDrive";
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("KilloughDrive");
        builder.addDoubleProperty("Left Motor Speed", this.m_leftMotor::get, this.m_leftMotor::set);
        builder.addDoubleProperty("Right Motor Speed", this.m_rightMotor::get, this.m_rightMotor::set);
        builder.addDoubleProperty("Back Motor Speed", this.m_backMotor::get, this.m_backMotor::set);
    }
}

