/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.drive;

import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.drive.RobotDriveBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class DifferentialDrive
extends RobotDriveBase {
    public static final double kDefaultQuickStopThreshold = 0.2;
    public static final double kDefaultQuickStopAlpha = 0.1;
    private static int instances = 0;
    private SpeedController m_leftMotor;
    private SpeedController m_rightMotor;
    private double m_quickStopThreshold = 0.2;
    private double m_quickStopAlpha = 0.1;
    private double m_quickStopAccumulator = 0.0;
    private boolean m_reported = false;

    public DifferentialDrive(SpeedController leftMotor, SpeedController rightMotor) {
        this.m_leftMotor = leftMotor;
        this.m_rightMotor = rightMotor;
        this.addChild(this.m_leftMotor);
        this.addChild(this.m_rightMotor);
        this.setName("DifferentialDrive", ++instances);
    }

    public void arcadeDrive(double xSpeed, double zRotation) {
        this.arcadeDrive(xSpeed, zRotation, true);
    }

    public void arcadeDrive(double xSpeed, double zRotation, boolean squaredInputs) {
        double rightMotorOutput;
        double leftMotorOutput;
        if (!this.m_reported) {
            HAL.report(31, 2, 1);
            this.m_reported = true;
        }
        xSpeed = this.limit(xSpeed);
        xSpeed = this.applyDeadband(xSpeed, this.m_deadband);
        zRotation = this.limit(zRotation);
        zRotation = this.applyDeadband(zRotation, this.m_deadband);
        if (squaredInputs) {
            xSpeed = Math.copySign(xSpeed * xSpeed, xSpeed);
            zRotation = Math.copySign(zRotation * zRotation, zRotation);
        }
        double maxInput = Math.copySign(Math.max(Math.abs(xSpeed), Math.abs(zRotation)), xSpeed);
        if (xSpeed >= 0.0) {
            if (zRotation >= 0.0) {
                leftMotorOutput = maxInput;
                rightMotorOutput = xSpeed - zRotation;
            } else {
                leftMotorOutput = xSpeed + zRotation;
                rightMotorOutput = maxInput;
            }
        } else if (zRotation >= 0.0) {
            leftMotorOutput = xSpeed + zRotation;
            rightMotorOutput = maxInput;
        } else {
            leftMotorOutput = maxInput;
            rightMotorOutput = xSpeed - zRotation;
        }
        this.m_leftMotor.set(this.limit(leftMotorOutput) * this.m_maxOutput);
        this.m_rightMotor.set(-this.limit(rightMotorOutput) * this.m_maxOutput);
        this.m_safetyHelper.feed();
    }

    public void curvatureDrive(double xSpeed, double zRotation, boolean isQuickTurn) {
        double angularPower;
        boolean overPower;
        if (!this.m_reported) {
            this.m_reported = true;
        }
        xSpeed = this.limit(xSpeed);
        xSpeed = this.applyDeadband(xSpeed, this.m_deadband);
        zRotation = this.limit(zRotation);
        zRotation = this.applyDeadband(zRotation, this.m_deadband);
        if (isQuickTurn) {
            if (Math.abs(xSpeed) < this.m_quickStopThreshold) {
                this.m_quickStopAccumulator = (1.0 - this.m_quickStopAlpha) * this.m_quickStopAccumulator + this.m_quickStopAlpha * this.limit(zRotation) * 2.0;
            }
            overPower = true;
            angularPower = zRotation;
        } else {
            overPower = false;
            angularPower = Math.abs(xSpeed) * zRotation - this.m_quickStopAccumulator;
            this.m_quickStopAccumulator = this.m_quickStopAccumulator > 1.0 ? (this.m_quickStopAccumulator -= 1.0) : (this.m_quickStopAccumulator < -1.0 ? (this.m_quickStopAccumulator += 1.0) : 0.0);
        }
        double leftMotorOutput = xSpeed + angularPower;
        double rightMotorOutput = xSpeed - angularPower;
        if (overPower) {
            if (leftMotorOutput > 1.0) {
                rightMotorOutput -= leftMotorOutput - 1.0;
                leftMotorOutput = 1.0;
            } else if (rightMotorOutput > 1.0) {
                leftMotorOutput -= rightMotorOutput - 1.0;
                rightMotorOutput = 1.0;
            } else if (leftMotorOutput < -1.0) {
                rightMotorOutput -= leftMotorOutput + 1.0;
                leftMotorOutput = -1.0;
            } else if (rightMotorOutput < -1.0) {
                leftMotorOutput -= rightMotorOutput + 1.0;
                rightMotorOutput = -1.0;
            }
        }
        this.m_leftMotor.set(leftMotorOutput * this.m_maxOutput);
        this.m_rightMotor.set(-rightMotorOutput * this.m_maxOutput);
        this.m_safetyHelper.feed();
    }

    public void tankDrive(double leftSpeed, double rightSpeed) {
        this.tankDrive(leftSpeed, rightSpeed, true);
    }

    public void tankDrive(double leftSpeed, double rightSpeed, boolean squaredInputs) {
        if (!this.m_reported) {
            HAL.report(31, 2, 4);
            this.m_reported = true;
        }
        leftSpeed = this.limit(leftSpeed);
        leftSpeed = this.applyDeadband(leftSpeed, this.m_deadband);
        rightSpeed = this.limit(rightSpeed);
        rightSpeed = this.applyDeadband(rightSpeed, this.m_deadband);
        if (squaredInputs) {
            leftSpeed = Math.copySign(leftSpeed * leftSpeed, leftSpeed);
            rightSpeed = Math.copySign(rightSpeed * rightSpeed, rightSpeed);
        }
        this.m_leftMotor.set(leftSpeed * this.m_maxOutput);
        this.m_rightMotor.set(-rightSpeed * this.m_maxOutput);
        this.m_safetyHelper.feed();
    }

    public void setQuickStopThreshold(double threshold) {
        this.m_quickStopThreshold = threshold;
    }

    public void setQuickStopAlpha(double alpha) {
        this.m_quickStopAlpha = alpha;
    }

    @Override
    public void stopMotor() {
        this.m_leftMotor.stopMotor();
        this.m_rightMotor.stopMotor();
        this.m_safetyHelper.feed();
    }

    @Override
    public String getDescription() {
        return "DifferentialDrive";
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("DifferentialDrive");
        builder.addDoubleProperty("Left Motor Speed", this.m_leftMotor::get, this.m_leftMotor::set);
        builder.addDoubleProperty("Right Motor Speed", () -> -this.m_rightMotor.get(), x -> this.m_rightMotor.set(-x));
    }
}

