/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.Enumeration;

public abstract class Subsystem
extends SendableBase
implements Sendable {
    private boolean m_initializedDefaultCommand = false;
    private Command m_currentCommand;
    private boolean m_currentCommandChanged;
    private Command m_defaultCommand;

    public Subsystem(String name) {
        this.setName(name, name);
        Scheduler.getInstance().registerSubsystem(this);
    }

    public Subsystem() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        this.setName(name, name);
        Scheduler.getInstance().registerSubsystem(this);
        this.m_currentCommandChanged = true;
    }

    protected abstract void initDefaultCommand();

    public void periodic() {
    }

    public void setDefaultCommand(Command command) {
        if (command == null) {
            this.m_defaultCommand = null;
        } else {
            boolean found = false;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                if (!requirements.nextElement().equals(this)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalUseOfCommandException("A default command must require the subsystem");
            }
            this.m_defaultCommand = command;
        }
    }

    public Command getDefaultCommand() {
        if (!this.m_initializedDefaultCommand) {
            this.m_initializedDefaultCommand = true;
            this.initDefaultCommand();
        }
        return this.m_defaultCommand;
    }

    public String getDefaultCommandName() {
        Command defaultCommand = this.getDefaultCommand();
        if (defaultCommand != null) {
            return defaultCommand.getName();
        }
        return "";
    }

    void setCurrentCommand(Command command) {
        this.m_currentCommand = command;
        this.m_currentCommandChanged = true;
    }

    void confirmCommand() {
        if (this.m_currentCommandChanged) {
            this.m_currentCommandChanged = false;
        }
    }

    public Command getCurrentCommand() {
        return this.m_currentCommand;
    }

    public String getCurrentCommandName() {
        Command currentCommand = this.getCurrentCommand();
        if (currentCommand != null) {
            return currentCommand.getName();
        }
        return "";
    }

    public void addChild(String name, Sendable child) {
        child.setName(this.getSubsystem(), name);
        LiveWindow.add(child);
    }

    public void addChild(Sendable child) {
        child.setSubsystem(this.getSubsystem());
        LiveWindow.add(child);
    }

    public String toString() {
        return this.getSubsystem();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Subsystem");
        builder.addBooleanProperty(".hasDefault", () -> this.m_defaultCommand != null, null);
        builder.addStringProperty(".default", this::getDefaultCommandName, null);
        builder.addBooleanProperty(".hasCommand", () -> this.m_currentCommand != null, null);
        builder.addStringProperty(".command", this::getCurrentCommandName, null);
    }
}

