/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.PIDController;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Subsystem;

public abstract class PIDSubsystem
extends Subsystem
implements Sendable {
    private final PIDController m_controller;
    private final PIDOutput m_output = this::usePIDOutput;
    private final PIDSource m_source = new PIDSource(){

        @Override
        public void setPIDSourceType(PIDSourceType pidSource) {
        }

        @Override
        public PIDSourceType getPIDSourceType() {
            return PIDSourceType.kDisplacement;
        }

        @Override
        public double pidGet() {
            return PIDSubsystem.this.returnPIDInput();
        }
    };

    public PIDSubsystem(String name, double p, double i, double d) {
        super(name);
        this.m_controller = new PIDController(p, i, d, this.m_source, this.m_output);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDSubsystem(String name, double p, double i, double d, double f) {
        super(name);
        this.m_controller = new PIDController(p, i, d, f, this.m_source, this.m_output);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDSubsystem(String name, double p, double i, double d, double f, double period) {
        super(name);
        this.m_controller = new PIDController(p, i, d, f, this.m_source, this.m_output, period);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDSubsystem(double p, double i, double d) {
        this.m_controller = new PIDController(p, i, d, this.m_source, this.m_output);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDSubsystem(double p, double i, double d, double period, double f) {
        this.m_controller = new PIDController(p, i, d, f, this.m_source, this.m_output, period);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDSubsystem(double p, double i, double d, double period) {
        this.m_controller = new PIDController(p, i, d, this.m_source, this.m_output, period);
        this.addChild("PIDController", this.m_controller);
    }

    public PIDController getPIDController() {
        return this.m_controller;
    }

    public void setSetpointRelative(double deltaSetpoint) {
        this.setSetpoint(this.getPosition() + deltaSetpoint);
    }

    public void setSetpoint(double setpoint) {
        this.m_controller.setSetpoint(setpoint);
    }

    public double getSetpoint() {
        return this.m_controller.getSetpoint();
    }

    public double getPosition() {
        return this.returnPIDInput();
    }

    public void setInputRange(double minimumInput, double maximumInput) {
        this.m_controller.setInputRange(minimumInput, maximumInput);
    }

    public void setOutputRange(double minimumOutput, double maximumOutput) {
        this.m_controller.setOutputRange(minimumOutput, maximumOutput);
    }

    public void setAbsoluteTolerance(double t) {
        this.m_controller.setAbsoluteTolerance(t);
    }

    public void setPercentTolerance(double p) {
        this.m_controller.setPercentTolerance(p);
    }

    public boolean onTarget() {
        return this.m_controller.onTarget();
    }

    protected abstract double returnPIDInput();

    protected abstract void usePIDOutput(double var1);

    public void enable() {
        this.m_controller.enable();
    }

    public void disable() {
        this.m_controller.disable();
    }
}

