/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Subsystem;
import java.util.Enumeration;

public abstract class ConditionalCommand
extends Command {
    private Command m_onTrue;
    private Command m_onFalse;
    private Command m_chosenCommand = null;

    private void requireAll() {
        Enumeration e;
        if (this.m_onTrue != null) {
            e = this.m_onTrue.getRequirements();
            while (e.hasMoreElements()) {
                this.requires((Subsystem)e.nextElement());
            }
        }
        if (this.m_onFalse != null) {
            e = this.m_onFalse.getRequirements();
            while (e.hasMoreElements()) {
                this.requires((Subsystem)e.nextElement());
            }
        }
    }

    public ConditionalCommand(Command onTrue) {
        this(onTrue, null);
    }

    public ConditionalCommand(Command onTrue, Command onFalse) {
        this.m_onTrue = onTrue;
        this.m_onFalse = onFalse;
        this.requireAll();
    }

    public ConditionalCommand(String name, Command onTrue) {
        this(name, onTrue, null);
    }

    public ConditionalCommand(String name, Command onTrue, Command onFalse) {
        super(name);
        this.m_onTrue = onTrue;
        this.m_onFalse = onFalse;
        this.requireAll();
    }

    protected abstract boolean condition();

    @Override
    protected void _initialize() {
        this.m_chosenCommand = this.condition() ? this.m_onTrue : this.m_onFalse;
        if (this.m_chosenCommand != null) {
            this.m_chosenCommand.clearRequirements();
            this.m_chosenCommand.start();
        }
    }

    @Override
    protected void _cancel() {
        if (this.m_chosenCommand != null && this.m_chosenCommand.isRunning()) {
            this.m_chosenCommand.cancel();
        }
        super._cancel();
    }

    @Override
    protected boolean isFinished() {
        return this.m_chosenCommand != null && this.m_chosenCommand.isRunning() && this.m_chosenCommand.isFinished();
    }

    @Override
    protected void interrupted() {
        if (this.m_chosenCommand != null && this.m_chosenCommand.isRunning()) {
            this.m_chosenCommand.cancel();
        }
        super.interrupted();
    }
}

