/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Subsystem;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;

public class CommandGroup
extends Command {
    private final Vector<Entry> m_commands = new Vector();
    final Vector<Entry> m_children = new Vector();
    private int m_currentCommandIndex = -1;

    public CommandGroup() {
    }

    public CommandGroup(String name) {
        super(name);
    }

    public final synchronized void addSequential(Command command) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new IllegalArgumentException("Given null command");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 0));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addSequential(Command command, double timeout) {
        this.validate("Can not add new command to command group");
        if (command == null) {
            throw new IllegalArgumentException("Given null command");
        }
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Can not be given a negative timeout");
        }
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 0, timeout));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addParallel(Command command) {
        Objects.requireNonNull(command, "Provided command was null");
        this.validate("Can not add new command to command group");
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 2));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    public final synchronized void addParallel(Command command, double timeout) {
        Objects.requireNonNull(command, "Provided command was null");
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Can not be given a negative timeout");
        }
        this.validate("Can not add new command to command group");
        command.setParent(this);
        this.m_commands.addElement(new Entry(command, 2, timeout));
        Enumeration e = command.getRequirements();
        while (e.hasMoreElements()) {
            this.requires((Subsystem)e.nextElement());
        }
    }

    @Override
    void _initialize() {
        this.m_currentCommandIndex = -1;
    }

    @Override
    void _execute() {
        Entry entry = null;
        Command cmd = null;
        boolean firstRun = false;
        if (this.m_currentCommandIndex == -1) {
            firstRun = true;
            this.m_currentCommandIndex = 0;
        }
        block5: while (this.m_currentCommandIndex < this.m_commands.size()) {
            if (cmd != null) {
                if (entry.isTimedOut()) {
                    cmd._cancel();
                }
                if (cmd.run()) break;
                cmd.removed();
                ++this.m_currentCommandIndex;
                firstRun = true;
                cmd = null;
                continue;
            }
            entry = this.m_commands.elementAt(this.m_currentCommandIndex);
            cmd = null;
            switch (entry.m_state) {
                case 0: {
                    cmd = entry.m_command;
                    if (firstRun) {
                        cmd.startRunning();
                        this.cancelConflicts(cmd);
                    }
                    firstRun = false;
                    continue block5;
                }
                case 1: {
                    ++this.m_currentCommandIndex;
                    entry.m_command.start();
                    continue block5;
                }
                case 2: {
                    ++this.m_currentCommandIndex;
                    this.cancelConflicts(entry.m_command);
                    entry.m_command.startRunning();
                    this.m_children.addElement(entry);
                    continue block5;
                }
            }
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            entry = this.m_children.elementAt(i);
            Command child = entry.m_command;
            if (entry.isTimedOut()) {
                child._cancel();
            }
            if (child.run()) continue;
            child.removed();
            this.m_children.removeElementAt(i--);
        }
    }

    @Override
    void _end() {
        if (this.m_currentCommandIndex != -1 && this.m_currentCommandIndex < this.m_commands.size()) {
            Command cmd = this.m_commands.elementAt(this.m_currentCommandIndex).m_command;
            cmd._cancel();
            cmd.removed();
        }
        Enumeration<Entry> children = this.m_children.elements();
        while (children.hasMoreElements()) {
            Command cmd = children.nextElement().m_command;
            cmd._cancel();
            cmd.removed();
        }
        this.m_children.removeAllElements();
    }

    @Override
    void _interrupted() {
        this._end();
    }

    @Override
    protected boolean isFinished() {
        return this.m_currentCommandIndex >= this.m_commands.size() && this.m_children.isEmpty();
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void execute() {
    }

    @Override
    protected void end() {
    }

    @Override
    protected void interrupted() {
    }

    @Override
    public synchronized boolean isInterruptible() {
        Command cmd;
        if (!super.isInterruptible()) {
            return false;
        }
        if (this.m_currentCommandIndex != -1 && this.m_currentCommandIndex < this.m_commands.size() && !(cmd = this.m_commands.elementAt(this.m_currentCommandIndex).m_command).isInterruptible()) {
            return false;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.elementAt(i).m_command.isInterruptible()) continue;
            return false;
        }
        return true;
    }

    private void cancelConflicts(Command command) {
        block0: for (int i = 0; i < this.m_children.size(); ++i) {
            Command child = this.m_children.elementAt(i).m_command;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                Object requirement = requirements.nextElement();
                if (!child.doesRequire((Subsystem)requirement)) continue;
                child._cancel();
                child.removed();
                this.m_children.removeElementAt(i--);
                continue block0;
            }
        }
    }

    private static class Entry {
        private static final int IN_SEQUENCE = 0;
        private static final int BRANCH_PEER = 1;
        private static final int BRANCH_CHILD = 2;
        private final Command m_command;
        private final int m_state;
        private final double m_timeout;

        Entry(Command command, int state) {
            this.m_command = command;
            this.m_state = state;
            this.m_timeout = -1.0;
        }

        Entry(Command command, int state, double timeout) {
            this.m_command = command;
            this.m_state = state;
            this.m_timeout = timeout;
        }

        boolean isTimedOut() {
            if (this.m_timeout == -1.0) {
                return false;
            }
            double time = this.m_command.timeSinceInitialized();
            return time != 0.0 && time >= this.m_timeout;
        }
    }
}

