/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.command.CommandGroup;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.command.Set;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.Enumeration;

public abstract class Command
extends SendableBase
implements Sendable {
    private double m_startTime = -1.0;
    private double m_timeout = -1.0;
    private boolean m_initialized = false;
    private final Set m_requirements = new Set();
    private boolean m_running = false;
    private boolean m_interruptible = true;
    private boolean m_canceled = false;
    private boolean m_locked = false;
    private boolean m_runWhenDisabled = false;
    private CommandGroup m_parent;

    public Command() {
        super(false);
        String name = this.getClass().getName();
        this.setName(name.substring(name.lastIndexOf(46) + 1));
    }

    public Command(String name) {
        super(false);
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        this.setName(name);
    }

    public Command(double timeout) {
        this();
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Timeout must not be negative.  Given:" + timeout);
        }
        this.m_timeout = timeout;
    }

    public Command(String name, double timeout) {
        this(name);
        if (timeout < 0.0) {
            throw new IllegalArgumentException("Timeout must not be negative.  Given:" + timeout);
        }
        this.m_timeout = timeout;
    }

    protected final synchronized void setTimeout(double seconds) {
        if (seconds < 0.0) {
            throw new IllegalArgumentException("Seconds must be positive.  Given:" + seconds);
        }
        this.m_timeout = seconds;
    }

    public final synchronized double timeSinceInitialized() {
        return this.m_startTime < 0.0 ? 0.0 : Timer.getFPGATimestamp() - this.m_startTime;
    }

    protected synchronized void requires(Subsystem subsystem) {
        this.validate("Can not add new requirement to command");
        if (subsystem == null) {
            throw new IllegalArgumentException("Subsystem must not be null.");
        }
        this.m_requirements.add(subsystem);
    }

    synchronized void removed() {
        if (this.m_initialized) {
            if (this.isCanceled()) {
                this.interrupted();
                this._interrupted();
            } else {
                this.end();
                this._end();
            }
        }
        this.m_initialized = false;
        this.m_canceled = false;
        this.m_running = false;
    }

    synchronized boolean run() {
        if (!this.m_runWhenDisabled && this.m_parent == null && RobotState.isDisabled()) {
            this.cancel();
        }
        if (this.isCanceled()) {
            return false;
        }
        if (!this.m_initialized) {
            this.m_initialized = true;
            this.startTiming();
            this._initialize();
            this.initialize();
        }
        this._execute();
        this.execute();
        return !this.isFinished();
    }

    protected void initialize() {
    }

    void _initialize() {
    }

    protected void execute() {
    }

    void _execute() {
    }

    protected abstract boolean isFinished();

    protected void end() {
    }

    void _end() {
    }

    protected void interrupted() {
        this.end();
    }

    void _interrupted() {
    }

    private void startTiming() {
        this.m_startTime = Timer.getFPGATimestamp();
    }

    protected synchronized boolean isTimedOut() {
        return this.m_timeout != -1.0 && this.timeSinceInitialized() >= this.m_timeout;
    }

    synchronized Enumeration getRequirements() {
        return this.m_requirements.getElements();
    }

    synchronized void lockChanges() {
        this.m_locked = true;
    }

    synchronized void validate(String message) {
        if (this.m_locked) {
            throw new IllegalUseOfCommandException(message + " after being started or being added to a command group");
        }
    }

    synchronized void setParent(CommandGroup parent) {
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not give command to a command group after already being put in a command group");
        }
        this.lockChanges();
        this.m_parent = parent;
    }

    synchronized boolean isParented() {
        return this.m_parent != null;
    }

    protected void clearRequirements() {
        this.m_requirements.clear();
    }

    public synchronized void start() {
        this.lockChanges();
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not start a command that is a part of a command group");
        }
        Scheduler.getInstance().add(this);
    }

    synchronized void startRunning() {
        this.m_running = true;
        this.m_startTime = -1.0;
    }

    public synchronized boolean isRunning() {
        return this.m_running;
    }

    public synchronized void cancel() {
        if (this.m_parent != null) {
            throw new IllegalUseOfCommandException("Can not manually cancel a command in a command group");
        }
        this._cancel();
    }

    synchronized void _cancel() {
        if (this.isRunning()) {
            this.m_canceled = true;
        }
    }

    public synchronized boolean isCanceled() {
        return this.m_canceled;
    }

    public synchronized boolean isInterruptible() {
        return this.m_interruptible;
    }

    protected synchronized void setInterruptible(boolean interruptible) {
        this.m_interruptible = interruptible;
    }

    public synchronized boolean doesRequire(Subsystem system) {
        return this.m_requirements.contains(system);
    }

    public synchronized CommandGroup getGroup() {
        return this.m_parent;
    }

    public void setRunWhenDisabled(boolean run) {
        this.m_runWhenDisabled = run;
    }

    public boolean willRunWhenDisabled() {
        return this.m_runWhenDisabled;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Command");
        builder.addStringProperty(".name", this::getName, null);
        builder.addBooleanProperty("running", this::isRunning, value -> {
            if (value) {
                if (!this.isRunning()) {
                    this.start();
                }
            } else if (this.isRunning()) {
                this.cancel();
            }
        });
        builder.addBooleanProperty(".isParented", this::isParented, null);
    }
}

