/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.buttons;

import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public abstract class Trigger
extends SendableBase {
    private volatile boolean m_sendablePressed = false;

    public abstract boolean get();

    private boolean grab() {
        return this.get() || this.m_sendablePressed;
    }

    public void whenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        command.start();
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    public void whileActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    this.m_pressedLast = true;
                    command.start();
                } else if (this.m_pressedLast) {
                    this.m_pressedLast = false;
                    command.cancel();
                }
            }
        }.start();
    }

    public void whenInactive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    this.m_pressedLast = true;
                } else if (this.m_pressedLast) {
                    this.m_pressedLast = false;
                    command.start();
                }
            }
        }.start();
    }

    public void toggleWhenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        if (command.isRunning()) {
                            command.cancel();
                        } else {
                            command.start();
                        }
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    public void cancelWhenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        command.cancel();
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Button");
        builder.setSafeState(() -> {
            this.m_sendablePressed = false;
        });
        builder.addBooleanProperty("pressed", this::grab, value -> {
            this.m_sendablePressed = value;
        });
    }

    public abstract class ButtonScheduler {
        public abstract void execute();

        protected void start() {
            Scheduler.getInstance().addButton(this);
        }
    }
}

