/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.hal.HAL;

public class XboxController
extends GenericHID {
    public XboxController(int port) {
        super(port);
        HAL.report(24, port);
    }

    @Override
    public double getX(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(0);
        }
        return this.getRawAxis(4);
    }

    @Override
    public double getY(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(1);
        }
        return this.getRawAxis(5);
    }

    public double getTriggerAxis(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(2);
        }
        return this.getRawAxis(3);
    }

    public boolean getBumper(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawButton(Button.kBumperLeft.value);
        }
        return this.getRawButton(Button.kBumperRight.value);
    }

    public boolean getBumperPressed(GenericHID.Hand hand) {
        if (hand == GenericHID.Hand.kLeft) {
            return this.getRawButtonPressed(Button.kBumperLeft.value);
        }
        return this.getRawButtonPressed(Button.kBumperRight.value);
    }

    public boolean getBumperReleased(GenericHID.Hand hand) {
        if (hand == GenericHID.Hand.kLeft) {
            return this.getRawButtonReleased(Button.kBumperLeft.value);
        }
        return this.getRawButtonReleased(Button.kBumperRight.value);
    }

    public boolean getStickButton(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawButton(Button.kStickLeft.value);
        }
        return this.getRawButton(Button.kStickRight.value);
    }

    public boolean getStickButtonPressed(GenericHID.Hand hand) {
        if (hand == GenericHID.Hand.kLeft) {
            return this.getRawButtonPressed(Button.kStickLeft.value);
        }
        return this.getRawButtonPressed(Button.kStickRight.value);
    }

    public boolean getStickButtonReleased(GenericHID.Hand hand) {
        if (hand == GenericHID.Hand.kLeft) {
            return this.getRawButtonReleased(Button.kStickLeft.value);
        }
        return this.getRawButtonReleased(Button.kStickRight.value);
    }

    public boolean getAButton() {
        return this.getRawButton(Button.kA.value);
    }

    public boolean getAButtonPressed() {
        return this.getRawButtonPressed(Button.kA.value);
    }

    public boolean getAButtonReleased() {
        return this.getRawButtonReleased(Button.kA.value);
    }

    public boolean getBButton() {
        return this.getRawButton(Button.kB.value);
    }

    public boolean getBButtonPressed() {
        return this.getRawButtonPressed(Button.kB.value);
    }

    public boolean getBButtonReleased() {
        return this.getRawButtonReleased(Button.kB.value);
    }

    public boolean getXButton() {
        return this.getRawButton(Button.kX.value);
    }

    public boolean getXButtonPressed() {
        return this.getRawButtonPressed(Button.kX.value);
    }

    public boolean getXButtonReleased() {
        return this.getRawButtonReleased(Button.kX.value);
    }

    public boolean getYButton() {
        return this.getRawButton(Button.kY.value);
    }

    public boolean getYButtonPressed() {
        return this.getRawButtonPressed(Button.kY.value);
    }

    public boolean getYButtonReleased() {
        return this.getRawButtonReleased(Button.kY.value);
    }

    public boolean getBackButton() {
        return this.getRawButton(Button.kBack.value);
    }

    public boolean getBackButtonPressed() {
        return this.getRawButtonPressed(Button.kBack.value);
    }

    public boolean getBackButtonReleased() {
        return this.getRawButtonReleased(Button.kBack.value);
    }

    public boolean getStartButton() {
        return this.getRawButton(Button.kStart.value);
    }

    public boolean getStartButtonPressed() {
        return this.getRawButtonPressed(Button.kStart.value);
    }

    public boolean getStartButtonReleased() {
        return this.getRawButtonReleased(Button.kStart.value);
    }

    private static enum Button {
        kBumperLeft(5),
        kBumperRight(6),
        kStickLeft(9),
        kStickRight(10),
        kA(1),
        kB(2),
        kX(3),
        kY(4),
        kBack(7),
        kStart(8);

        private int value;

        private Button(int value) {
            this.value = value;
        }
    }
}

