/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class SpeedControllerGroup
extends SendableBase
implements SpeedController {
    private boolean m_isInverted = false;
    private final SpeedController[] m_speedControllers;
    private static int instances = 0;

    public SpeedControllerGroup(SpeedController speedController, SpeedController ... speedControllers) {
        this.m_speedControllers = new SpeedController[speedControllers.length + 1];
        this.m_speedControllers[0] = speedController;
        this.addChild(speedController);
        for (int i = 0; i < speedControllers.length; ++i) {
            this.m_speedControllers[i + 1] = speedControllers[i];
            this.addChild(speedControllers[i]);
        }
        this.setName("SpeedControllerGroup", ++instances);
    }

    @Override
    public void set(double speed) {
        for (SpeedController speedController : this.m_speedControllers) {
            speedController.set(this.m_isInverted ? -speed : speed);
        }
    }

    @Override
    public double get() {
        if (this.m_speedControllers.length > 0) {
            return this.m_speedControllers[0].get();
        }
        return 0.0;
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.m_isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.m_isInverted;
    }

    @Override
    public void disable() {
        for (SpeedController speedController : this.m_speedControllers) {
            speedController.disable();
        }
    }

    @Override
    public void stopMotor() {
        for (SpeedController speedController : this.m_speedControllers) {
            speedController.stopMotor();
        }
    }

    @Override
    public void pidWrite(double output) {
        for (SpeedController speedController : this.m_speedControllers) {
            speedController.pidWrite(output);
        }
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Speed Controller");
        builder.setSafeState(this::stopMotor);
        builder.addDoubleProperty("Value", this::get, this::set);
    }
}

