/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class Solenoid
extends SolenoidBase
implements Sendable {
    private final int m_channel;
    private int m_solenoidHandle;

    public Solenoid(int channel) {
        this(SensorBase.getDefaultSolenoidModule(), channel);
    }

    public Solenoid(int moduleNumber, int channel) {
        super(moduleNumber);
        this.m_channel = channel;
        SensorBase.checkSolenoidModule(this.m_moduleNumber);
        SensorBase.checkSolenoidChannel(this.m_channel);
        int portHandle = SolenoidJNI.getPortWithModule((byte)this.m_moduleNumber, (byte)this.m_channel);
        this.m_solenoidHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        HAL.report(34, this.m_channel, this.m_moduleNumber);
        this.setName("Solenoid", this.m_moduleNumber, this.m_channel);
    }

    @Override
    public synchronized void free() {
        super.free();
        SolenoidJNI.freeSolenoidPort(this.m_solenoidHandle);
        this.m_solenoidHandle = 0;
    }

    public void set(boolean on) {
        SolenoidJNI.setSolenoid(this.m_solenoidHandle, on);
    }

    public boolean get() {
        return SolenoidJNI.getSolenoid(this.m_solenoidHandle);
    }

    public boolean isBlackListed() {
        int value = this.getPCMSolenoidBlackList() & 1 << this.m_channel;
        return value != 0;
    }

    public void setPulseDuration(double durationSeconds) {
        long durationMS = (long)(durationSeconds * 1000.0);
        SolenoidJNI.setOneShotDuration(this.m_solenoidHandle, durationMS);
    }

    public void startPulse() {
        SolenoidJNI.fireOneShot(this.m_solenoidHandle);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Solenoid");
        builder.setSafeState(() -> this.set(false));
        builder.addBooleanProperty("Value", this::get, this::set);
    }
}

