/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;

public abstract class SendableBase
implements Sendable {
    private String m_name = "";
    private String m_subsystem = "Ungrouped";

    public SendableBase() {
        this(true);
    }

    public SendableBase(boolean addLiveWindow) {
        if (addLiveWindow) {
            LiveWindow.add(this);
        }
    }

    public void free() {
        LiveWindow.remove(this);
    }

    @Override
    public final synchronized String getName() {
        return this.m_name;
    }

    @Override
    public final synchronized void setName(String name) {
        this.m_name = name;
    }

    protected final void setName(String moduleType, int channel) {
        this.setName(moduleType + "[" + channel + "]");
    }

    protected final void setName(String moduleType, int moduleNumber, int channel) {
        this.setName(moduleType + "[" + moduleNumber + "," + channel + "]");
    }

    @Override
    public final synchronized String getSubsystem() {
        return this.m_subsystem;
    }

    @Override
    public final synchronized void setSubsystem(String subsystem) {
        this.m_subsystem = subsystem;
    }

    protected final void addChild(Object child) {
        LiveWindow.addChild(this, child);
    }
}

