/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.Talon;
import edu.wpi.first.wpilibj.hal.HAL;
import java.util.Objects;

@Deprecated
public class RobotDrive
implements MotorSafety {
    protected MotorSafetyHelper m_safetyHelper;
    public static final double kDefaultExpirationTime = 0.1;
    public static final double kDefaultSensitivity = 0.5;
    public static final double kDefaultMaxOutput = 1.0;
    protected static final int kMaxNumberOfMotors = 4;
    protected double m_sensitivity;
    protected double m_maxOutput;
    protected SpeedController m_frontLeftMotor;
    protected SpeedController m_frontRightMotor;
    protected SpeedController m_rearLeftMotor;
    protected SpeedController m_rearRightMotor;
    protected boolean m_allocatedSpeedControllers;
    protected static boolean kArcadeRatioCurve_Reported = false;
    protected static boolean kTank_Reported = false;
    protected static boolean kArcadeStandard_Reported = false;
    protected static boolean kMecanumCartesian_Reported = false;
    protected static boolean kMecanumPolar_Reported = false;

    public RobotDrive(int leftMotorChannel, int rightMotorChannel) {
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = new Talon(leftMotorChannel);
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = new Talon(rightMotorChannel);
        this.m_allocatedSpeedControllers = true;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(int frontLeftMotor, int rearLeftMotor, int frontRightMotor, int rearRightMotor) {
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_rearLeftMotor = new Talon(rearLeftMotor);
        this.m_rearRightMotor = new Talon(rearRightMotor);
        this.m_frontLeftMotor = new Talon(frontLeftMotor);
        this.m_frontRightMotor = new Talon(frontRightMotor);
        this.m_allocatedSpeedControllers = true;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(SpeedController leftMotor, SpeedController rightMotor) {
        Objects.requireNonNull(leftMotor, "Provided left motor was null");
        Objects.requireNonNull(rightMotor, "Provided right motor was null");
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = leftMotor;
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = rightMotor;
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_allocatedSpeedControllers = false;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(SpeedController frontLeftMotor, SpeedController rearLeftMotor, SpeedController frontRightMotor, SpeedController rearRightMotor) {
        this.m_frontLeftMotor = Objects.requireNonNull(frontLeftMotor, "frontLeftMotor cannot be null");
        this.m_rearLeftMotor = Objects.requireNonNull(rearLeftMotor, "rearLeftMotor cannot be null");
        this.m_frontRightMotor = Objects.requireNonNull(frontRightMotor, "frontRightMotor cannot be null");
        this.m_rearRightMotor = Objects.requireNonNull(rearRightMotor, "rearRightMotor cannot be null");
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_allocatedSpeedControllers = false;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public void drive(double outputMagnitude, double curve) {
        double rightOutput;
        double leftOutput;
        if (!kArcadeRatioCurve_Reported) {
            HAL.report(31, this.getNumMotors(), 3);
            kArcadeRatioCurve_Reported = true;
        }
        if (curve < 0.0) {
            double value = Math.log(-curve);
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftOutput = outputMagnitude / ratio;
            rightOutput = outputMagnitude;
        } else if (curve > 0.0) {
            double value = Math.log(curve);
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftOutput = outputMagnitude;
            rightOutput = outputMagnitude / ratio;
        } else {
            leftOutput = outputMagnitude;
            rightOutput = outputMagnitude;
        }
        this.setLeftRightMotorOutputs(leftOutput, rightOutput);
    }

    public void tankDrive(GenericHID leftStick, GenericHID rightStick) {
        Objects.requireNonNull(leftStick, "Provided left stick was null");
        Objects.requireNonNull(rightStick, "Provided right stick was null");
        this.tankDrive(leftStick.getY(), rightStick.getY(), true);
    }

    public void tankDrive(GenericHID leftStick, GenericHID rightStick, boolean squaredInputs) {
        Objects.requireNonNull(leftStick, "Provided left stick was null");
        Objects.requireNonNull(rightStick, "Provided right stick was null");
        this.tankDrive(leftStick.getY(), rightStick.getY(), squaredInputs);
    }

    public void tankDrive(GenericHID leftStick, int leftAxis, GenericHID rightStick, int rightAxis) {
        Objects.requireNonNull(leftStick, "Provided left stick was null");
        Objects.requireNonNull(rightStick, "Provided right stick was null");
        this.tankDrive(leftStick.getRawAxis(leftAxis), rightStick.getRawAxis(rightAxis), true);
    }

    public void tankDrive(GenericHID leftStick, int leftAxis, GenericHID rightStick, int rightAxis, boolean squaredInputs) {
        Objects.requireNonNull(leftStick, "Provided left stick was null");
        Objects.requireNonNull(rightStick, "Provided right stick was null");
        this.tankDrive(leftStick.getRawAxis(leftAxis), rightStick.getRawAxis(rightAxis), squaredInputs);
    }

    public void tankDrive(double leftValue, double rightValue, boolean squaredInputs) {
        if (!kTank_Reported) {
            HAL.report(31, this.getNumMotors(), 4);
            kTank_Reported = true;
        }
        leftValue = RobotDrive.limit(leftValue);
        rightValue = RobotDrive.limit(rightValue);
        if (squaredInputs) {
            leftValue = Math.copySign(leftValue * leftValue, leftValue);
            rightValue = Math.copySign(rightValue * rightValue, rightValue);
        }
        this.setLeftRightMotorOutputs(leftValue, rightValue);
    }

    public void tankDrive(double leftValue, double rightValue) {
        this.tankDrive(leftValue, rightValue, true);
    }

    public void arcadeDrive(GenericHID stick, boolean squaredInputs) {
        this.arcadeDrive(stick.getY(), stick.getX(), squaredInputs);
    }

    public void arcadeDrive(GenericHID stick) {
        this.arcadeDrive(stick, true);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis, boolean squaredInputs) {
        double moveValue = moveStick.getRawAxis(moveAxis);
        double rotateValue = rotateStick.getRawAxis(rotateAxis);
        this.arcadeDrive(moveValue, rotateValue, squaredInputs);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis) {
        this.arcadeDrive(moveStick, moveAxis, rotateStick, rotateAxis, true);
    }

    public void arcadeDrive(double moveValue, double rotateValue, boolean squaredInputs) {
        double rightMotorSpeed;
        double leftMotorSpeed;
        if (!kArcadeStandard_Reported) {
            HAL.report(31, this.getNumMotors(), 1);
            kArcadeStandard_Reported = true;
        }
        moveValue = RobotDrive.limit(moveValue);
        rotateValue = RobotDrive.limit(rotateValue);
        if (squaredInputs) {
            moveValue = Math.copySign(moveValue * moveValue, moveValue);
            rotateValue = Math.copySign(rotateValue * rotateValue, rotateValue);
        }
        if (moveValue > 0.0) {
            if (rotateValue > 0.0) {
                leftMotorSpeed = moveValue - rotateValue;
                rightMotorSpeed = Math.max(moveValue, rotateValue);
            } else {
                leftMotorSpeed = Math.max(moveValue, -rotateValue);
                rightMotorSpeed = moveValue + rotateValue;
            }
        } else if (rotateValue > 0.0) {
            leftMotorSpeed = -Math.max(-moveValue, rotateValue);
            rightMotorSpeed = moveValue + rotateValue;
        } else {
            leftMotorSpeed = moveValue - rotateValue;
            rightMotorSpeed = -Math.max(-moveValue, -rotateValue);
        }
        this.setLeftRightMotorOutputs(leftMotorSpeed, rightMotorSpeed);
    }

    public void arcadeDrive(double moveValue, double rotateValue) {
        this.arcadeDrive(moveValue, rotateValue, true);
    }

    public void mecanumDrive_Cartesian(double x, double y, double rotation, double gyroAngle) {
        if (!kMecanumCartesian_Reported) {
            HAL.report(31, this.getNumMotors(), 6);
            kMecanumCartesian_Reported = true;
        }
        double xIn = x;
        double yIn = y;
        yIn = -yIn;
        double[] rotated = RobotDrive.rotateVector(xIn, yIn, gyroAngle);
        xIn = rotated[0];
        yIn = rotated[1];
        double[] wheelSpeeds = new double[4];
        wheelSpeeds[MotorType.kFrontLeft.value] = xIn + yIn + rotation;
        wheelSpeeds[MotorType.kFrontRight.value] = -xIn + yIn - rotation;
        wheelSpeeds[MotorType.kRearLeft.value] = -xIn + yIn + rotation;
        wheelSpeeds[MotorType.kRearRight.value] = xIn + yIn - rotation;
        RobotDrive.normalize(wheelSpeeds);
        this.m_frontLeftMotor.set(wheelSpeeds[MotorType.kFrontLeft.value] * this.m_maxOutput);
        this.m_frontRightMotor.set(wheelSpeeds[MotorType.kFrontRight.value] * this.m_maxOutput);
        this.m_rearLeftMotor.set(wheelSpeeds[MotorType.kRearLeft.value] * this.m_maxOutput);
        this.m_rearRightMotor.set(wheelSpeeds[MotorType.kRearRight.value] * this.m_maxOutput);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    public void mecanumDrive_Polar(double magnitude, double direction, double rotation) {
        if (!kMecanumPolar_Reported) {
            HAL.report(31, this.getNumMotors(), 5);
            kMecanumPolar_Reported = true;
        }
        magnitude = RobotDrive.limit(magnitude) * Math.sqrt(2.0);
        double dirInRad = (direction + 45.0) * Math.PI / 180.0;
        double cosD = Math.cos(dirInRad);
        double sinD = Math.sin(dirInRad);
        double[] wheelSpeeds = new double[4];
        wheelSpeeds[MotorType.kFrontLeft.value] = sinD * magnitude + rotation;
        wheelSpeeds[MotorType.kFrontRight.value] = cosD * magnitude - rotation;
        wheelSpeeds[MotorType.kRearLeft.value] = cosD * magnitude + rotation;
        wheelSpeeds[MotorType.kRearRight.value] = sinD * magnitude - rotation;
        RobotDrive.normalize(wheelSpeeds);
        this.m_frontLeftMotor.set(wheelSpeeds[MotorType.kFrontLeft.value] * this.m_maxOutput);
        this.m_frontRightMotor.set(wheelSpeeds[MotorType.kFrontRight.value] * this.m_maxOutput);
        this.m_rearLeftMotor.set(wheelSpeeds[MotorType.kRearLeft.value] * this.m_maxOutput);
        this.m_rearRightMotor.set(wheelSpeeds[MotorType.kRearRight.value] * this.m_maxOutput);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    void holonomicDrive(double magnitude, double direction, double rotation) {
        this.mecanumDrive_Polar(magnitude, direction, rotation);
    }

    public void setLeftRightMotorOutputs(double leftOutput, double rightOutput) {
        Objects.requireNonNull(this.m_rearLeftMotor, "Provided left motor was null");
        Objects.requireNonNull(this.m_rearRightMotor, "Provided right motor was null");
        if (this.m_frontLeftMotor != null) {
            this.m_frontLeftMotor.set(RobotDrive.limit(leftOutput) * this.m_maxOutput);
        }
        this.m_rearLeftMotor.set(RobotDrive.limit(leftOutput) * this.m_maxOutput);
        if (this.m_frontRightMotor != null) {
            this.m_frontRightMotor.set(-RobotDrive.limit(rightOutput) * this.m_maxOutput);
        }
        this.m_rearRightMotor.set(-RobotDrive.limit(rightOutput) * this.m_maxOutput);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    protected static double limit(double number) {
        if (number > 1.0) {
            return 1.0;
        }
        if (number < -1.0) {
            return -1.0;
        }
        return number;
    }

    protected static void normalize(double[] wheelSpeeds) {
        int i;
        double maxMagnitude = Math.abs(wheelSpeeds[0]);
        for (i = 1; i < 4; ++i) {
            double temp = Math.abs(wheelSpeeds[i]);
            if (!(maxMagnitude < temp)) continue;
            maxMagnitude = temp;
        }
        if (maxMagnitude > 1.0) {
            for (i = 0; i < 4; ++i) {
                wheelSpeeds[i] = wheelSpeeds[i] / maxMagnitude;
            }
        }
    }

    protected static double[] rotateVector(double x, double y, double angle) {
        double cosA = Math.cos(angle * (Math.PI / 180));
        double sinA = Math.sin(angle * (Math.PI / 180));
        double[] out = new double[]{x * cosA - y * sinA, x * sinA + y * cosA};
        return out;
    }

    public void setInvertedMotor(MotorType motor, boolean isInverted) {
        switch (motor) {
            case kFrontLeft: {
                this.m_frontLeftMotor.setInverted(isInverted);
                break;
            }
            case kFrontRight: {
                this.m_frontRightMotor.setInverted(isInverted);
                break;
            }
            case kRearLeft: {
                this.m_rearLeftMotor.setInverted(isInverted);
                break;
            }
            case kRearRight: {
                this.m_rearRightMotor.setInverted(isInverted);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal motor type: " + (Object)((Object)motor));
            }
        }
    }

    public void setSensitivity(double sensitivity) {
        this.m_sensitivity = sensitivity;
    }

    public void setMaxOutput(double maxOutput) {
        this.m_maxOutput = maxOutput;
    }

    public void free() {
        if (this.m_allocatedSpeedControllers) {
            if (this.m_frontLeftMotor != null) {
                ((PWM)((Object)this.m_frontLeftMotor)).free();
            }
            if (this.m_frontRightMotor != null) {
                ((PWM)((Object)this.m_frontRightMotor)).free();
            }
            if (this.m_rearLeftMotor != null) {
                ((PWM)((Object)this.m_rearLeftMotor)).free();
            }
            if (this.m_rearRightMotor != null) {
                ((PWM)((Object)this.m_rearRightMotor)).free();
            }
        }
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "Robot Drive";
    }

    @Override
    public void stopMotor() {
        if (this.m_frontLeftMotor != null) {
            this.m_frontLeftMotor.stopMotor();
        }
        if (this.m_frontRightMotor != null) {
            this.m_frontRightMotor.stopMotor();
        }
        if (this.m_rearLeftMotor != null) {
            this.m_rearLeftMotor.stopMotor();
        }
        if (this.m_rearRightMotor != null) {
            this.m_rearRightMotor.stopMotor();
        }
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    private void setupMotorSafety() {
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_safetyHelper.setExpiration(0.1);
        this.m_safetyHelper.setSafetyEnabled(true);
    }

    protected int getNumMotors() {
        int motors = 0;
        if (this.m_frontLeftMotor != null) {
            ++motors;
        }
        if (this.m_frontRightMotor != null) {
            ++motors;
        }
        if (this.m_rearLeftMotor != null) {
            ++motors;
        }
        if (this.m_rearRightMotor != null) {
            ++motors;
        }
        return motors;
    }

    public static enum MotorType {
        kFrontLeft(0),
        kFrontRight(1),
        kRearLeft(2),
        kRearRight(3);

        public final int value;

        private MotorType(int value) {
            this.value = value;
        }
    }
}

