/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.cscore.CameraServerJNI;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.HLUsageReporting;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.HALUtil;
import edu.wpi.first.wpilibj.internal.HardwareHLUsageReporting;
import edu.wpi.first.wpilibj.internal.HardwareTimer;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;

public abstract class RobotBase {
    public static final int ROBOT_TASK_PRIORITY = 101;
    public static final long MAIN_THREAD_ID = Thread.currentThread().getId();
    protected final DriverStation m_ds;

    protected RobotBase() {
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        inst.setNetworkIdentity("Robot");
        inst.startServer("/home/lvuser/networktables.ini");
        this.m_ds = DriverStation.getInstance();
        inst.getTable("LiveWindow").getSubTable(".status").getEntry("LW Enabled").setBoolean(false);
        LiveWindow.setEnabled(false);
    }

    public void free() {
    }

    public static boolean isSimulation() {
        return !RobotBase.isReal();
    }

    public static boolean isReal() {
        return HALUtil.getHALRuntimeType() == 0;
    }

    public boolean isDisabled() {
        return this.m_ds.isDisabled();
    }

    public boolean isEnabled() {
        return this.m_ds.isEnabled();
    }

    public boolean isAutonomous() {
        return this.m_ds.isAutonomous();
    }

    public boolean isTest() {
        return this.m_ds.isTest();
    }

    public boolean isOperatorControl() {
        return this.m_ds.isOperatorControl();
    }

    public boolean isNewDataAvailable() {
        return this.m_ds.isNewControlData();
    }

    public abstract void startCompetition();

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String propVal = System.getProperty(name);
        if (propVal == null) {
            return defaultValue;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalStateException(propVal);
    }

    public static void initializeHardwareConfiguration() {
        if (!HAL.initialize(500, 0)) {
            throw new IllegalStateException("Failed to initialize. Terminating");
        }
        Timer.SetImplementation(new HardwareTimer());
        HLUsageReporting.SetImplementation(new HardwareHLUsageReporting());
        RobotState.SetImplementation(DriverStation.getInstance());
        CameraServerJNI.enumerateSinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        RobotBase robot;
        RobotBase.initializeHardwareConfiguration();
        HAL.report(2, 3);
        String robotName = "";
        Enumeration<URL> resources = null;
        try {
            resources = RobotBase.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        while (resources != null && resources.hasMoreElements()) {
            try {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                robotName = manifest.getMainAttributes().getValue("Robot-Class");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("********** Robot program starting **********");
        try {
            robot = (RobotBase)Class.forName(robotName).newInstance();
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                throwable = cause;
            }
            DriverStation.reportError("Unhandled exception instantiating robot " + robotName + " " + throwable.toString(), throwable.getStackTrace());
            DriverStation.reportWarning("Robots should not quit, but yours did!", false);
            DriverStation.reportError("Could not instantiate robot " + robotName + "!", false);
            System.exit(1);
            return;
        }
        try {
            File file = new File("/tmp/frc_versions/FRC_Lib_Version.ini");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            try (FileOutputStream output = new FileOutputStream(file);){
                output.write("Java ".getBytes());
                output.write("2018.1.1".getBytes());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        boolean errorOnExit = false;
        try {
            robot.startCompetition();
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                throwable = cause;
            }
            DriverStation.reportError("Unhandled exception: " + throwable.toString(), throwable.getStackTrace());
            errorOnExit = true;
        }
        finally {
            DriverStation.reportWarning("Robots should not quit, but yours did!", false);
            if (errorOnExit) {
                DriverStation.reportError("The startCompetition() method (or methods called by it) should have handled the exception above.", false);
            } else {
                DriverStation.reportError("Unexpected return from startCompetition() method.", false);
            }
        }
        System.exit(1);
    }
}

