/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj.hal.HAL;
import java.util.Objects;
import java.util.Vector;

public class Preferences {
    private static final String TABLE_NAME = "Preferences";
    private static Preferences instance;
    private final NetworkTable m_table = NetworkTableInstance.getDefault().getTable("Preferences");

    public static synchronized Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    private Preferences() {
        this.m_table.getEntry(".type").setString("RobotPreferences");
        this.m_table.addEntryListener((table, key, entry, value, flags) -> entry.setPersistent(), 5);
        HAL.report(28, 0);
    }

    public Vector<String> getKeys() {
        return new Vector<String>(this.m_table.getKeys());
    }

    public void putString(String key, String value) {
        Objects.requireNonNull(value, "Provided value was null");
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setString(value);
        entry.setPersistent();
    }

    public void putInt(String key, int value) {
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setDouble((double)value);
        entry.setPersistent();
    }

    public void putDouble(String key, double value) {
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setDouble(value);
        entry.setPersistent();
    }

    public void putFloat(String key, float value) {
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setDouble((double)value);
        entry.setPersistent();
    }

    public void putBoolean(String key, boolean value) {
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setBoolean(value);
        entry.setPersistent();
    }

    public void putLong(String key, long value) {
        NetworkTableEntry entry = this.m_table.getEntry(key);
        entry.setDouble((double)value);
        entry.setPersistent();
    }

    public boolean containsKey(String key) {
        return this.m_table.containsKey(key);
    }

    public void remove(String key) {
        this.m_table.delete(key);
    }

    public String getString(String key, String backup) {
        return this.m_table.getEntry(key).getString(backup);
    }

    public int getInt(String key, int backup) {
        return (int)this.m_table.getEntry(key).getDouble((double)backup);
    }

    public double getDouble(String key, double backup) {
        return this.m_table.getEntry(key).getDouble(backup);
    }

    public boolean getBoolean(String key, boolean backup) {
        return this.m_table.getEntry(key).getBoolean(backup);
    }

    public float getFloat(String key, float backup) {
        return (float)this.m_table.getEntry(key).getDouble((double)backup);
    }

    public long getLong(String key, long backup) {
        return (long)this.m_table.getEntry(key).getDouble((double)backup);
    }
}

