/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.PDPJNI;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class PowerDistributionPanel
extends SensorBase
implements Sendable {
    private final int m_module;

    public PowerDistributionPanel(int module) {
        this.m_module = module;
        PowerDistributionPanel.checkPDPModule(module);
        PDPJNI.initializePDP(module);
        this.setName("PowerDistributionPanel", module);
    }

    public PowerDistributionPanel() {
        this(0);
    }

    public double getVoltage() {
        return PDPJNI.getPDPVoltage(this.m_module);
    }

    public double getTemperature() {
        return PDPJNI.getPDPTemperature(this.m_module);
    }

    public double getCurrent(int channel) {
        double current = PDPJNI.getPDPChannelCurrent((byte)channel, this.m_module);
        PowerDistributionPanel.checkPDPChannel(channel);
        return current;
    }

    public double getTotalCurrent() {
        return PDPJNI.getPDPTotalCurrent(this.m_module);
    }

    public double getTotalPower() {
        return PDPJNI.getPDPTotalPower(this.m_module);
    }

    public double getTotalEnergy() {
        return PDPJNI.getPDPTotalEnergy(this.m_module);
    }

    public void resetTotalEnergy() {
        PDPJNI.resetPDPTotalEnergy(this.m_module);
    }

    public void clearStickyFaults() {
        PDPJNI.clearPDPStickyFaults(this.m_module);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("PowerDistributionPanel");
        for (int i = 0; i < kPDPChannels; ++i) {
            int chan = i;
            builder.addDoubleProperty("Chan" + i, () -> this.getCurrent(chan), null);
        }
        builder.addDoubleProperty("Voltage", this::getVoltage, null);
        builder.addDoubleProperty("TotalCurrent", this::getTotalCurrent, null);
    }
}

