/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Controller;
import edu.wpi.first.wpilibj.HLUsageReporting;
import edu.wpi.first.wpilibj.PIDInterface;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.filters.LinearDigitalFilter;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class PIDController
extends SendableBase
implements PIDInterface,
Sendable,
Controller {
    public static final double kDefaultPeriod = 0.05;
    private static int instances = 0;
    private double m_P;
    private double m_I;
    private double m_D;
    private double m_F;
    private double m_maximumOutput = 1.0;
    private double m_minimumOutput = -1.0;
    private double m_maximumInput = 0.0;
    private double m_minimumInput = 0.0;
    private double m_inputRange = 0.0;
    private boolean m_continuous = false;
    private boolean m_enabled = false;
    private double m_prevError = 0.0;
    private double m_totalError = 0.0;
    private Tolerance m_tolerance;
    private double m_setpoint = 0.0;
    private double m_prevSetpoint = 0.0;
    private double m_error = 0.0;
    private double m_result = 0.0;
    private double m_period = 0.05;
    PIDSource m_origSource;
    LinearDigitalFilter m_filter;
    ReentrantLock m_thisMutex = new ReentrantLock();
    ReentrantLock m_pidWriteMutex = new ReentrantLock();
    protected PIDSource m_pidInput;
    protected PIDOutput m_pidOutput;
    java.util.Timer m_controlLoop;
    Timer m_setpointTimer;

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output, double period) {
        super(false);
        Objects.requireNonNull(source, "Null PIDSource was given");
        Objects.requireNonNull(output, "Null PIDOutput was given");
        this.m_controlLoop = new java.util.Timer();
        this.m_setpointTimer = new Timer();
        this.m_setpointTimer.start();
        this.m_P = Kp;
        this.m_I = Ki;
        this.m_D = Kd;
        this.m_F = Kf;
        this.m_origSource = source;
        this.m_filter = LinearDigitalFilter.movingAverage(this.m_origSource, 1);
        this.m_pidInput = this.m_filter;
        this.m_pidOutput = output;
        this.m_period = period;
        this.m_controlLoop.schedule((TimerTask)new PIDTask(this), 0L, (long)(this.m_period * 1000.0));
        HLUsageReporting.reportPIDController(++instances);
        this.m_tolerance = new NullTolerance();
        this.setName("PIDController", instances);
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output, double period) {
        this(Kp, Ki, Kd, 0.0, source, output, period);
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, source, output, 0.05);
    }

    public PIDController(double Kp, double Ki, double Kd, double Kf, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, Kf, source, output, 0.05);
    }

    @Override
    public void free() {
        super.free();
        this.m_controlLoop.cancel();
        this.m_thisMutex.lock();
        try {
            this.m_pidOutput = null;
            this.m_pidInput = null;
            this.m_controlLoop = null;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculate() {
        boolean enabled;
        if (this.m_origSource == null || this.m_pidOutput == null) {
            return;
        }
        this.m_thisMutex.lock();
        try {
            enabled = this.m_enabled;
        }
        finally {
            this.m_thisMutex.unlock();
        }
        if (enabled) {
            double result;
            double totalError;
            double error;
            double prevError;
            double maximumOutput;
            double minimumOutput;
            double D;
            double I;
            double P;
            PIDSourceType pidSourceType;
            double feedForward = this.calculateFeedForward();
            this.m_thisMutex.lock();
            try {
                double input = this.m_pidInput.pidGet();
                pidSourceType = this.m_pidInput.getPIDSourceType();
                P = this.m_P;
                I = this.m_I;
                D = this.m_D;
                minimumOutput = this.m_minimumOutput;
                maximumOutput = this.m_maximumOutput;
                prevError = this.m_prevError;
                error = this.getContinuousError(this.m_setpoint - input);
                totalError = this.m_totalError;
            }
            finally {
                this.m_thisMutex.unlock();
            }
            if (pidSourceType.equals((Object)PIDSourceType.kRate)) {
                if (P != 0.0) {
                    totalError = PIDController.clamp(totalError + error, minimumOutput / P, maximumOutput / P);
                }
                result = P * totalError + D * error + feedForward;
            } else {
                if (I != 0.0) {
                    totalError = PIDController.clamp(totalError + error, minimumOutput / I, maximumOutput / I);
                }
                result = P * error + I * totalError + D * (error - prevError) + feedForward;
            }
            result = PIDController.clamp(result, minimumOutput, maximumOutput);
            this.m_pidWriteMutex.lock();
            try {
                this.m_thisMutex.lock();
                try {
                    if (this.m_enabled) {
                        this.m_thisMutex.unlock();
                        this.m_pidOutput.pidWrite(result);
                    }
                }
                finally {
                    if (this.m_thisMutex.isHeldByCurrentThread()) {
                        this.m_thisMutex.unlock();
                    }
                }
            }
            finally {
                this.m_pidWriteMutex.unlock();
            }
            this.m_thisMutex.lock();
            try {
                this.m_prevError = error;
                this.m_error = error;
                this.m_totalError = totalError;
                this.m_result = result;
            }
            finally {
                this.m_thisMutex.unlock();
            }
        }
    }

    protected double calculateFeedForward() {
        if (this.m_pidInput.getPIDSourceType().equals((Object)PIDSourceType.kRate)) {
            return this.m_F * this.getSetpoint();
        }
        double temp = this.m_F * this.getDeltaSetpoint();
        this.m_prevSetpoint = this.m_setpoint;
        this.m_setpointTimer.reset();
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPID(double p, double i, double d) {
        this.m_thisMutex.lock();
        try {
            this.m_P = p;
            this.m_I = i;
            this.m_D = d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPID(double p, double i, double d, double f) {
        this.m_thisMutex.lock();
        try {
            this.m_P = p;
            this.m_I = i;
            this.m_D = d;
            this.m_F = f;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setP(double p) {
        this.m_thisMutex.lock();
        try {
            this.m_P = p;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setI(double i) {
        this.m_thisMutex.lock();
        try {
            this.m_I = i;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setD(double d) {
        this.m_thisMutex.lock();
        try {
            this.m_D = d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setF(double f) {
        this.m_thisMutex.lock();
        try {
            this.m_F = f;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public double getP() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_P;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public double getI() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_I;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public double getD() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_D;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public double getF() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_F;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public double get() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_result;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setContinuous(boolean continuous) {
        this.m_thisMutex.lock();
        try {
            this.m_continuous = continuous;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setContinuous() {
        this.setContinuous(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputRange(double minimumInput, double maximumInput) {
        this.m_thisMutex.lock();
        try {
            if (minimumInput > maximumInput) {
                throw new BoundaryException("Lower bound is greater than upper bound");
            }
            this.m_minimumInput = minimumInput;
            this.m_maximumInput = maximumInput;
            this.m_inputRange = maximumInput - minimumInput;
        }
        finally {
            this.m_thisMutex.unlock();
        }
        this.setSetpoint(this.m_setpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputRange(double minimumOutput, double maximumOutput) {
        this.m_thisMutex.lock();
        try {
            if (minimumOutput > maximumOutput) {
                throw new BoundaryException("Lower bound is greater than upper bound");
            }
            this.m_minimumOutput = minimumOutput;
            this.m_maximumOutput = maximumOutput;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public void setSetpoint(double setpoint) {
        this.m_thisMutex.lock();
        try {
            this.m_setpoint = this.m_maximumInput > this.m_minimumInput ? (setpoint > this.m_maximumInput ? this.m_maximumInput : (setpoint < this.m_minimumInput ? this.m_minimumInput : setpoint)) : setpoint;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public double getSetpoint() {
        this.m_thisMutex.lock();
        try {
            double d = this.m_setpoint;
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public double getDeltaSetpoint() {
        this.m_thisMutex.lock();
        try {
            double d = (this.m_setpoint - this.m_prevSetpoint) / this.m_setpointTimer.get();
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public double getError() {
        this.m_thisMutex.lock();
        try {
            double d = this.getContinuousError(this.getSetpoint() - this.m_pidInput.pidGet());
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Deprecated
    public double getAvgError() {
        this.m_thisMutex.lock();
        try {
            double d = this.getError();
            return d;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidInput.setPIDSourceType(pidSource);
    }

    PIDSourceType getPIDSourceType() {
        return this.m_pidInput.getPIDSourceType();
    }

    @Deprecated
    public void setTolerance(Tolerance tolerance) {
        this.m_tolerance = tolerance;
    }

    public void setAbsoluteTolerance(double absvalue) {
        this.m_thisMutex.lock();
        try {
            this.m_tolerance = new AbsoluteTolerance(absvalue);
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public void setPercentTolerance(double percentage) {
        this.m_thisMutex.lock();
        try {
            this.m_tolerance = new PercentageTolerance(percentage);
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Deprecated
    public void setToleranceBuffer(int bufLength) {
        this.m_thisMutex.lock();
        try {
            this.m_filter = LinearDigitalFilter.movingAverage(this.m_origSource, bufLength);
            this.m_pidInput = this.m_filter;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    public boolean onTarget() {
        this.m_thisMutex.lock();
        try {
            boolean bl = this.m_tolerance.onTarget();
            return bl;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public void enable() {
        this.m_thisMutex.lock();
        try {
            this.m_enabled = true;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public void disable() {
        this.m_pidWriteMutex.lock();
        try {
            this.m_thisMutex.lock();
            try {
                this.m_enabled = false;
            }
            finally {
                this.m_thisMutex.unlock();
            }
            this.m_pidOutput.pidWrite(0.0);
        }
        finally {
            this.m_pidWriteMutex.unlock();
        }
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    @Override
    public boolean isEnabled() {
        this.m_thisMutex.lock();
        try {
            boolean bl = this.m_enabled;
            return bl;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public void reset() {
        this.disable();
        this.m_thisMutex.lock();
        try {
            this.m_prevError = 0.0;
            this.m_totalError = 0.0;
            this.m_result = 0.0;
        }
        finally {
            this.m_thisMutex.unlock();
        }
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("PIDController");
        builder.setSafeState(this::reset);
        builder.addDoubleProperty("p", this::getP, this::setP);
        builder.addDoubleProperty("i", this::getI, this::setI);
        builder.addDoubleProperty("d", this::getD, this::setD);
        builder.addDoubleProperty("f", this::getF, this::setF);
        builder.addDoubleProperty("setpoint", this::getSetpoint, this::setSetpoint);
        builder.addBooleanProperty("enabled", this::isEnabled, this::setEnabled);
    }

    protected double getContinuousError(double error) {
        if (this.m_continuous && Math.abs(error %= this.m_inputRange) > this.m_inputRange / 2.0) {
            if (error > 0.0) {
                return error - this.m_inputRange;
            }
            return error + this.m_inputRange;
        }
        return error;
    }

    private static double clamp(double value, double low, double high) {
        return Math.max(low, Math.min(value, high));
    }

    private class PIDTask
    extends TimerTask {
        private PIDController m_controller;

        PIDTask(PIDController controller) {
            Objects.requireNonNull(controller, "Given PIDController was null");
            this.m_controller = controller;
        }

        @Override
        public void run() {
            this.m_controller.calculate();
        }
    }

    public class AbsoluteTolerance
    implements Tolerance {
        private final double m_value;

        AbsoluteTolerance(double value) {
            this.m_value = value;
        }

        @Override
        public boolean onTarget() {
            return Math.abs(PIDController.this.getError()) < this.m_value;
        }
    }

    public class PercentageTolerance
    implements Tolerance {
        private final double m_percentage;

        PercentageTolerance(double value) {
            this.m_percentage = value;
        }

        @Override
        public boolean onTarget() {
            return Math.abs(PIDController.this.getError()) < this.m_percentage / 100.0 * PIDController.this.m_inputRange;
        }
    }

    public class NullTolerance
    implements Tolerance {
        @Override
        public boolean onTarget() {
            throw new RuntimeException("No tolerance value set when calling onTarget().");
        }
    }

    public static interface Tolerance {
        public boolean onTarget();
    }
}

