/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotController;
import edu.wpi.first.wpilibj.hal.NotifierJNI;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class Notifier {
    private final Thread m_thread;
    private final ReentrantLock m_processLock = new ReentrantLock();
    private final AtomicInteger m_notifier = new AtomicInteger();
    private double m_expirationTime = 0.0;
    private Runnable m_handler;
    private boolean m_periodic = false;
    private double m_period = 0.0;

    protected void finalize() {
        int handle = this.m_notifier.getAndSet(0);
        NotifierJNI.stopNotifier(handle);
        if (this.m_thread.isAlive()) {
            try {
                this.m_thread.interrupt();
                this.m_thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        NotifierJNI.cleanNotifier(handle);
    }

    private void updateAlarm() {
        int notifier = this.m_notifier.get();
        if (notifier == 0) {
            return;
        }
        NotifierJNI.updateNotifierAlarm(notifier, (long)(this.m_expirationTime * 1000000.0));
    }

    public Notifier(Runnable run) {
        this.m_handler = run;
        this.m_notifier.set(NotifierJNI.initializeNotifier());
        this.m_thread = new Thread(() -> {
            long curTime;
            int notifier;
            while (!Thread.interrupted() && (notifier = this.m_notifier.get()) != 0 && (curTime = NotifierJNI.waitForNotifierAlarm(notifier)) != 0L) {
                Runnable handler = null;
                this.m_processLock.lock();
                try {
                    handler = this.m_handler;
                    if (this.m_periodic) {
                        this.m_expirationTime += this.m_period;
                        this.updateAlarm();
                    }
                }
                finally {
                    this.m_processLock.unlock();
                }
                if (handler == null) continue;
                handler.run();
            }
        });
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public void setHandler(Runnable handler) {
        this.m_processLock.lock();
        try {
            this.m_handler = handler;
        }
        finally {
            this.m_processLock.unlock();
        }
    }

    public void startSingle(double delay) {
        this.m_processLock.lock();
        try {
            this.m_periodic = false;
            this.m_period = delay;
            this.m_expirationTime = (double)RobotController.getFPGATime() * 1.0E-6 + delay;
            this.updateAlarm();
        }
        finally {
            this.m_processLock.unlock();
        }
    }

    public void startPeriodic(double period) {
        this.m_processLock.lock();
        try {
            this.m_periodic = true;
            this.m_period = period;
            this.m_expirationTime = (double)RobotController.getFPGATime() * 1.0E-6 + period;
            this.updateAlarm();
        }
        finally {
            this.m_processLock.unlock();
        }
    }

    public void stop() {
        NotifierJNI.cancelNotifierAlarm(this.m_notifier.get());
    }
}

