/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalOutput;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class NidecBrushless
extends SendableBase
implements SpeedController,
MotorSafety,
Sendable {
    private final MotorSafetyHelper m_safetyHelper = new MotorSafetyHelper(this);
    private boolean m_isInverted = false;
    private DigitalOutput m_dio;
    private PWM m_pwm;
    private volatile double m_speed = 0.0;
    private volatile boolean m_disabled = false;

    public NidecBrushless(int pwmChannel, int dioChannel) {
        this.m_safetyHelper.setExpiration(0.0);
        this.m_safetyHelper.setSafetyEnabled(false);
        this.m_dio = new DigitalOutput(dioChannel);
        this.addChild(this.m_dio);
        this.m_dio.setPWMRate(15625.0);
        this.m_dio.enablePWM(0.5);
        this.m_pwm = new PWM(pwmChannel);
        this.addChild(this.m_pwm);
        HAL.report(62, pwmChannel);
        this.setName("Nidec Brushless", pwmChannel);
    }

    @Override
    public void free() {
        super.free();
        this.m_dio.free();
        this.m_pwm.free();
    }

    @Override
    public void set(double speed) {
        if (!this.m_disabled) {
            this.m_speed = speed;
            this.m_dio.updateDutyCycle(0.5 + 0.5 * (this.m_isInverted ? -speed : speed));
            this.m_pwm.setRaw(65535);
        }
        this.m_safetyHelper.feed();
    }

    @Override
    public double get() {
        return this.m_speed;
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.m_isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.m_isInverted;
    }

    @Override
    public void pidWrite(double output) {
        this.set(output);
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public void stopMotor() {
        this.m_dio.updateDutyCycle(0.5);
        this.m_pwm.setDisabled();
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "Nidec " + this.getChannel();
    }

    @Override
    public void disable() {
        this.m_disabled = true;
        this.m_dio.updateDutyCycle(0.5);
        this.m_pwm.setDisabled();
    }

    public void enable() {
        this.m_disabled = false;
    }

    public int getChannel() {
        return this.m_pwm.getChannel();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Nidec Brushless");
        builder.setSafeState(this::stopMotor);
        builder.addDoubleProperty("Value", this::get, this::set);
    }
}

