/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.hal.HAL;

public class Joystick
extends GenericHID {
    static final byte kDefaultXAxis = 0;
    static final byte kDefaultYAxis = 1;
    static final byte kDefaultZAxis = 2;
    static final byte kDefaultTwistAxis = 2;
    static final byte kDefaultThrottleAxis = 3;
    private final byte[] m_axes;

    public Joystick(int port) {
        super(port);
        this.m_axes = new byte[Axis.kNumAxes.value];
        this.m_axes[Axis.kX.value] = 0;
        this.m_axes[Axis.kY.value] = 1;
        this.m_axes[Axis.kZ.value] = 2;
        this.m_axes[Axis.kTwist.value] = 2;
        this.m_axes[Axis.kThrottle.value] = 3;
        HAL.report(24, port);
    }

    public void setXChannel(int channel) {
        this.m_axes[Axis.kX.value] = (byte)channel;
    }

    public void setYChannel(int channel) {
        this.m_axes[Axis.kY.value] = (byte)channel;
    }

    public void setZChannel(int channel) {
        this.m_axes[Axis.kZ.value] = (byte)channel;
    }

    public void setThrottleChannel(int channel) {
        this.m_axes[Axis.kThrottle.value] = (byte)channel;
    }

    public void setTwistChannel(int channel) {
        this.m_axes[Axis.kTwist.value] = (byte)channel;
    }

    @Deprecated
    public void setAxisChannel(AxisType axis, int channel) {
        this.m_axes[axis.value] = (byte)channel;
    }

    public int getXChannel() {
        return this.m_axes[Axis.kX.value];
    }

    public int getYChannel() {
        return this.m_axes[Axis.kY.value];
    }

    public int getZChannel() {
        return this.m_axes[Axis.kZ.value];
    }

    public int getTwistChannel() {
        return this.m_axes[Axis.kTwist.value];
    }

    public int getThrottleChannel() {
        return this.m_axes[Axis.kThrottle.value];
    }

    @Deprecated
    public int getAxisChannel(AxisType axis) {
        return this.m_axes[axis.value];
    }

    @Override
    public final double getX(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[Axis.kX.value]);
    }

    @Override
    public final double getY(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[Axis.kY.value]);
    }

    public double getZ() {
        return this.getRawAxis(this.m_axes[Axis.kZ.value]);
    }

    public double getTwist() {
        return this.getRawAxis(this.m_axes[Axis.kTwist.value]);
    }

    public double getThrottle() {
        return this.getRawAxis(this.m_axes[Axis.kThrottle.value]);
    }

    @Deprecated
    public double getAxis(AxisType axis) {
        switch (axis) {
            case kX: {
                return this.getX();
            }
            case kY: {
                return this.getY();
            }
            case kZ: {
                return this.getZ();
            }
            case kTwist: {
                return this.getTwist();
            }
            case kThrottle: {
                return this.getThrottle();
            }
        }
        return 0.0;
    }

    public boolean getTrigger() {
        return this.getRawButton(Button.kTrigger.value);
    }

    public boolean getTriggerPressed() {
        return this.getRawButtonPressed(Button.kTrigger.value);
    }

    public boolean getTriggerReleased() {
        return this.getRawButtonReleased(Button.kTrigger.value);
    }

    public boolean getTop() {
        return this.getRawButton(Button.kTop.value);
    }

    public boolean getTopPressed() {
        return this.getRawButtonPressed(Button.kTop.value);
    }

    public boolean getTopReleased() {
        return this.getRawButtonReleased(Button.kTop.value);
    }

    @Deprecated
    public boolean getButton(ButtonType button) {
        return this.getRawButton(button.value);
    }

    public double getMagnitude() {
        return Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0));
    }

    public double getDirectionRadians() {
        return Math.atan2(this.getX(), -this.getY());
    }

    public double getDirectionDegrees() {
        return Math.toDegrees(this.getDirectionRadians());
    }

    private static enum Axis {
        kX(0),
        kY(1),
        kZ(2),
        kTwist(3),
        kThrottle(4),
        kNumAxes(5);

        public final int value;

        private Axis(int value) {
            this.value = value;
        }
    }

    private static enum Button {
        kTrigger(1),
        kTop(2);

        public final int value;

        private Button(int value) {
            this.value = value;
        }
    }

    public static enum ButtonType {
        kTrigger(1),
        kTop(2);

        public final int value;

        private ButtonType(int value) {
            this.value = value;
        }
    }

    public static enum AxisType {
        kX(0),
        kY(1),
        kZ(2),
        kTwist(3),
        kThrottle(4);

        public final int value;

        private AxisType(int value) {
            this.value = value;
        }
    }
}

