/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

public abstract class IterativeRobotBase
extends RobotBase {
    private Mode m_lastMode = Mode.kNone;
    private boolean m_rpFirstRun = true;
    private boolean m_dpFirstRun = true;
    private boolean m_apFirstRun = true;
    private boolean m_tpFirstRun = true;
    private boolean m_tmpFirstRun = true;

    @Override
    public abstract void startCompetition();

    public void robotInit() {
        System.out.println("Default robotInit() method... Overload me!");
    }

    public void disabledInit() {
        System.out.println("Default disabledInit() method... Overload me!");
    }

    public void autonomousInit() {
        System.out.println("Default autonomousInit() method... Overload me!");
    }

    public void teleopInit() {
        System.out.println("Default teleopInit() method... Overload me!");
    }

    public void testInit() {
        System.out.println("Default testInit() method... Overload me!");
    }

    public void robotPeriodic() {
        if (this.m_rpFirstRun) {
            System.out.println("Default robotPeriodic() method... Overload me!");
            this.m_rpFirstRun = false;
        }
    }

    public void disabledPeriodic() {
        if (this.m_dpFirstRun) {
            System.out.println("Default disabledPeriodic() method... Overload me!");
            this.m_dpFirstRun = false;
        }
    }

    public void autonomousPeriodic() {
        if (this.m_apFirstRun) {
            System.out.println("Default autonomousPeriodic() method... Overload me!");
            this.m_apFirstRun = false;
        }
    }

    public void teleopPeriodic() {
        if (this.m_tpFirstRun) {
            System.out.println("Default teleopPeriodic() method... Overload me!");
            this.m_tpFirstRun = false;
        }
    }

    public void testPeriodic() {
        if (this.m_tmpFirstRun) {
            System.out.println("Default testPeriodic() method... Overload me!");
            this.m_tmpFirstRun = false;
        }
    }

    protected void loopFunc() {
        if (this.isDisabled()) {
            if (this.m_lastMode != Mode.kDisabled) {
                LiveWindow.setEnabled(false);
                this.disabledInit();
                this.m_lastMode = Mode.kDisabled;
            }
            HAL.observeUserProgramDisabled();
            this.disabledPeriodic();
        } else if (this.isAutonomous()) {
            if (this.m_lastMode != Mode.kAutonomous) {
                LiveWindow.setEnabled(false);
                this.autonomousInit();
                this.m_lastMode = Mode.kAutonomous;
            }
            HAL.observeUserProgramAutonomous();
            this.autonomousPeriodic();
        } else if (this.isOperatorControl()) {
            if (this.m_lastMode != Mode.kTeleop) {
                LiveWindow.setEnabled(false);
                this.teleopInit();
                this.m_lastMode = Mode.kTeleop;
            }
            HAL.observeUserProgramTeleop();
            this.teleopPeriodic();
        } else {
            if (this.m_lastMode != Mode.kTest) {
                LiveWindow.setEnabled(true);
                this.testInit();
                this.m_lastMode = Mode.kTest;
            }
            HAL.observeUserProgramTest();
            this.testPeriodic();
        }
        this.robotPeriodic();
        SmartDashboard.updateValues();
        LiveWindow.updateValues();
    }

    private static enum Mode {
        kNone,
        kDisabled,
        kAutonomous,
        kTeleop,
        kTest;

    }
}

