/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.InterruptHandlerFunction;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.InterruptJNI;
import edu.wpi.first.wpilibj.util.AllocationException;

public abstract class InterruptableSensorBase
extends SensorBase {
    protected int m_interrupt = 0;
    protected boolean m_isSynchronousInterrupt = false;

    @Override
    public void free() {
        super.free();
        if (this.m_interrupt != 0) {
            this.cancelInterrupts();
        }
    }

    public abstract int getAnalogTriggerTypeForRouting();

    public abstract int getPortHandleForRouting();

    public void requestInterrupts(InterruptHandlerFunction<?> handler) {
        if (this.m_interrupt != 0) {
            throw new AllocationException("The interrupt has already been allocated");
        }
        this.allocateInterrupts(false);
        assert (this.m_interrupt != 0);
        InterruptJNI.requestInterrupts(this.m_interrupt, this.getPortHandleForRouting(), this.getAnalogTriggerTypeForRouting());
        this.setUpSourceEdge(true, false);
        InterruptJNI.attachInterruptHandler(this.m_interrupt, handler.m_function, handler.overridableParameter());
    }

    public void requestInterrupts() {
        if (this.m_interrupt != 0) {
            throw new AllocationException("The interrupt has already been allocated");
        }
        this.allocateInterrupts(true);
        assert (this.m_interrupt != 0);
        InterruptJNI.requestInterrupts(this.m_interrupt, this.getPortHandleForRouting(), this.getAnalogTriggerTypeForRouting());
        this.setUpSourceEdge(true, false);
    }

    protected void allocateInterrupts(boolean watcher) {
        this.m_isSynchronousInterrupt = watcher;
        this.m_interrupt = InterruptJNI.initializeInterrupts(watcher);
    }

    public void cancelInterrupts() {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        InterruptJNI.cleanInterrupts(this.m_interrupt);
        this.m_interrupt = 0;
    }

    public WaitResult waitForInterrupt(double timeout, boolean ignorePrevious) {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        int result = InterruptJNI.waitForInterrupt(this.m_interrupt, timeout, ignorePrevious);
        int rising = (result & 0xFF) != 0 ? 1 : 0;
        int falling = (result & 0xFF00) != 0 ? 256 : 0;
        result = rising | falling;
        for (WaitResult mode : WaitResult.values()) {
            if (mode.value != result) continue;
            return mode;
        }
        return null;
    }

    public WaitResult waitForInterrupt(double timeout) {
        return this.waitForInterrupt(timeout, true);
    }

    public void enableInterrupts() {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        if (this.m_isSynchronousInterrupt) {
            throw new IllegalStateException("You do not need to enable synchronous interrupts");
        }
        InterruptJNI.enableInterrupts(this.m_interrupt);
    }

    public void disableInterrupts() {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        if (this.m_isSynchronousInterrupt) {
            throw new IllegalStateException("You can not disable synchronous interrupts");
        }
        InterruptJNI.disableInterrupts(this.m_interrupt);
    }

    public double readRisingTimestamp() {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        return InterruptJNI.readInterruptRisingTimestamp(this.m_interrupt);
    }

    public double readFallingTimestamp() {
        if (this.m_interrupt == 0) {
            throw new IllegalStateException("The interrupt is not allocated.");
        }
        return InterruptJNI.readInterruptFallingTimestamp(this.m_interrupt);
    }

    public void setUpSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_interrupt == 0) {
            throw new IllegalArgumentException("You must call RequestInterrupts before setUpSourceEdge");
        }
        InterruptJNI.setInterruptUpSourceEdge(this.m_interrupt, risingEdge, fallingEdge);
    }

    public static enum WaitResult {
        kTimeout(0),
        kRisingEdge(1),
        kFallingEdge(256),
        kBoth(257);

        public final int value;

        private WaitResult(int value) {
            this.value = value;
        }
    }
}

