/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.hal.HAL;

public abstract class GenericHID {
    private DriverStation m_ds = DriverStation.getInstance();
    private final int m_port;
    private int m_outputs;
    private short m_leftRumble;
    private short m_rightRumble;

    public GenericHID(int port) {
        this.m_port = port;
    }

    public final double getX() {
        return this.getX(Hand.kRight);
    }

    public abstract double getX(Hand var1);

    public final double getY() {
        return this.getY(Hand.kRight);
    }

    public abstract double getY(Hand var1);

    public boolean getRawButton(int button) {
        return this.m_ds.getStickButton(this.m_port, (byte)button);
    }

    public boolean getRawButtonPressed(int button) {
        return this.m_ds.getStickButtonPressed(this.m_port, (byte)button);
    }

    public boolean getRawButtonReleased(int button) {
        return this.m_ds.getStickButtonReleased(this.m_port, button);
    }

    public double getRawAxis(int axis) {
        return this.m_ds.getStickAxis(this.m_port, axis);
    }

    public int getPOV(int pov) {
        return this.m_ds.getStickPOV(this.m_port, pov);
    }

    public int getPOV() {
        return this.getPOV(0);
    }

    public int getAxisCount() {
        return this.m_ds.getStickAxisCount(this.m_port);
    }

    public int getPOVCount() {
        return this.m_ds.getStickPOVCount(this.m_port);
    }

    public int getButtonCount() {
        return this.m_ds.getStickButtonCount(this.m_port);
    }

    public HIDType getType() {
        return HIDType.values()[this.m_ds.getJoystickType(this.m_port)];
    }

    public String getName() {
        return this.m_ds.getJoystickName(this.m_port);
    }

    public int getAxisType(int axis) {
        return this.m_ds.getJoystickAxisType(this.m_port, axis);
    }

    public int getPort() {
        return this.m_port;
    }

    public void setOutput(int outputNumber, boolean value) {
        this.m_outputs = this.m_outputs & ~(1 << outputNumber - 1) | (value ? 1 : 0) << outputNumber - 1;
        HAL.setJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public void setOutputs(int value) {
        this.m_outputs = value;
        HAL.setJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public void setRumble(RumbleType type, double value) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        if (type == RumbleType.kLeftRumble) {
            this.m_leftRumble = (short)(value * 65535.0);
        } else {
            this.m_rightRumble = (short)(value * 65535.0);
        }
        HAL.setJoystickOutputs((byte)this.m_port, this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public static enum Hand {
        kLeft(0),
        kRight(1);

        public final int value;

        private Hand(int value) {
            this.value = value;
        }
    }

    public static enum HIDType {
        kUnknown(-1),
        kXInputUnknown(0),
        kXInputGamepad(1),
        kXInputWheel(2),
        kXInputArcadeStick(3),
        kXInputFlightStick(4),
        kXInputDancePad(5),
        kXInputGuitar(6),
        kXInputGuitar2(7),
        kXInputDrumKit(8),
        kXInputGuitar3(11),
        kXInputArcadePad(19),
        kHIDJoystick(20),
        kHIDGamepad(21),
        kHIDDriving(22),
        kHIDFlight(23),
        kHID1stPerson(24);

        public final int value;

        private HIDType(int value) {
            this.value = value;
        }
    }

    public static enum RumbleType {
        kLeftRumble,
        kRightRumble;

    }
}

