/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class GearTooth
extends Counter {
    private static final double kGearToothThreshold = 5.5E-5;

    public void enableDirectionSensing(boolean directionSensitive) {
        if (directionSensitive) {
            this.setPulseLengthMode(5.5E-5);
        }
    }

    public GearTooth(int channel) {
        this(channel, false);
    }

    public GearTooth(int channel, boolean directionSensitive) {
        super(channel);
        this.enableDirectionSensing(directionSensitive);
        if (directionSensitive) {
            HAL.report(19, channel, 0, "D");
        } else {
            HAL.report(19, channel, 0);
        }
        this.setName("GearTooth", channel);
    }

    public GearTooth(DigitalSource source, boolean directionSensitive) {
        super(source);
        this.enableDirectionSensing(directionSensitive);
        if (directionSensitive) {
            HAL.report(19, source.getChannel(), 0, "D");
        } else {
            HAL.report(19, source.getChannel(), 0);
        }
        this.setName("GearTooth", source.getChannel());
    }

    public GearTooth(DigitalSource source) {
        this(source, false);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        super.initSendable(builder);
        builder.setSmartDashboardType("Gear Tooth");
    }
}

