/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.hal.AllianceStationID;
import edu.wpi.first.wpilibj.hal.ControlWord;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.MatchInfoData;
import edu.wpi.first.wpilibj.hal.PowerJNI;
import java.nio.ByteBuffer;

public class DriverStation
implements RobotState.Interface {
    public static final int kJoystickPorts = 6;
    private static final double JOYSTICK_UNPLUGGED_MESSAGE_INTERVAL = 1.0;
    private double m_nextMessageTime = 0.0;
    private static DriverStation instance = new DriverStation();
    private HALJoystickAxes[] m_joystickAxes = new HALJoystickAxes[6];
    private HALJoystickPOVs[] m_joystickPOVs = new HALJoystickPOVs[6];
    private HALJoystickButtons[] m_joystickButtons = new HALJoystickButtons[6];
    private MatchInfoData m_matchInfo = new MatchInfoData();
    private HALJoystickAxes[] m_joystickAxesCache = new HALJoystickAxes[6];
    private HALJoystickPOVs[] m_joystickPOVsCache = new HALJoystickPOVs[6];
    private HALJoystickButtons[] m_joystickButtonsCache = new HALJoystickButtons[6];
    private MatchInfoData m_matchInfoCache = new MatchInfoData();
    HALJoystickButtons[] m_joystickButtonsPressed = new HALJoystickButtons[6];
    HALJoystickButtons[] m_joystickButtonsReleased = new HALJoystickButtons[6];
    private ByteBuffer m_buttonCountBuffer = ByteBuffer.allocateDirect(1);
    private Thread m_thread;
    private volatile boolean m_threadKeepAlive = true;
    private final Object m_cacheDataMutex = new Object();
    private boolean m_userInDisabled = false;
    private boolean m_userInAutonomous = false;
    private boolean m_userInTeleop = false;
    private boolean m_userInTest = false;
    private final Object m_controlWordMutex;
    private ControlWord m_controlWordCache;
    private long m_lastControlWordUpdate;

    public static DriverStation getInstance() {
        return instance;
    }

    private DriverStation() {
        for (int i = 0; i < 6; ++i) {
            this.m_joystickButtons[i] = new HALJoystickButtons();
            this.m_joystickAxes[i] = new HALJoystickAxes(HAL.kMaxJoystickAxes);
            this.m_joystickPOVs[i] = new HALJoystickPOVs(HAL.kMaxJoystickPOVs);
            this.m_joystickButtonsCache[i] = new HALJoystickButtons();
            this.m_joystickAxesCache[i] = new HALJoystickAxes(HAL.kMaxJoystickAxes);
            this.m_joystickPOVsCache[i] = new HALJoystickPOVs(HAL.kMaxJoystickPOVs);
            this.m_joystickButtonsPressed[i] = new HALJoystickButtons();
            this.m_joystickButtonsReleased[i] = new HALJoystickButtons();
        }
        this.m_controlWordMutex = new Object();
        this.m_controlWordCache = new ControlWord();
        this.m_lastControlWordUpdate = 0L;
        this.m_thread = new Thread((Runnable)new DriverStationTask(this), "FRCDriverStation");
        this.m_thread.setPriority(7);
        this.m_thread.start();
    }

    public void release() {
        this.m_threadKeepAlive = false;
    }

    public static void reportError(String error, boolean printTrace) {
        DriverStation.reportErrorImpl(true, 1, error, printTrace);
    }

    public static void reportError(String error, StackTraceElement[] stackTrace) {
        DriverStation.reportErrorImpl(true, 1, error, stackTrace);
    }

    public static void reportWarning(String error, boolean printTrace) {
        DriverStation.reportErrorImpl(false, 1, error, printTrace);
    }

    public static void reportWarning(String error, StackTraceElement[] stackTrace) {
        DriverStation.reportErrorImpl(false, 1, error, stackTrace);
    }

    private static void reportErrorImpl(boolean isError, int code, String error, boolean printTrace) {
        DriverStation.reportErrorImpl(isError, code, error, printTrace, Thread.currentThread().getStackTrace(), 3);
    }

    private static void reportErrorImpl(boolean isError, int code, String error, StackTraceElement[] stackTrace) {
        DriverStation.reportErrorImpl(isError, code, error, true, stackTrace, 0);
    }

    private static void reportErrorImpl(boolean isError, int code, String error, boolean printTrace, StackTraceElement[] stackTrace, int stackTraceFirst) {
        String locString = stackTrace.length >= stackTraceFirst + 1 ? stackTrace[stackTraceFirst].toString() : "";
        String traceString = "";
        if (printTrace) {
            boolean haveLoc = false;
            for (int i = stackTraceFirst; i < stackTrace.length; ++i) {
                String loc = stackTrace[i].toString();
                traceString = traceString + "\tat " + loc + "\n";
                if (haveLoc || loc.startsWith("edu.wpi.first")) continue;
                locString = loc;
                haveLoc = true;
            }
        }
        HAL.sendError(isError, code, false, error, locString, traceString, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStickButton(int stick, int button) {
        if (button <= 0) {
            this.reportJoystickUnpluggedError("Button indexes begin at 1 in WPILib for C++ and Java\n");
            return false;
        }
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        boolean error = false;
        boolean retVal = false;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (button > this.m_joystickButtons[stick].m_count) {
                error = true;
                retVal = false;
            } else {
                retVal = (this.m_joystickButtons[stick].m_buttons & 1 << button - 1) != 0;
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick Button " + button + " on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    boolean getStickButtonPressed(int stick, int button) {
        if (button <= 0) {
            this.reportJoystickUnpluggedError("Button indexes begin at 1 in WPILib for C++ and Java\n");
            return false;
        }
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        if ((this.m_joystickButtonsPressed[stick].m_buttons & 1 << button - 1) != 0) {
            this.m_joystickButtonsPressed[stick].m_buttons &= ~(1 << button - 1);
            return true;
        }
        return false;
    }

    boolean getStickButtonReleased(int stick, int button) {
        if (button <= 0) {
            this.reportJoystickUnpluggedError("Button indexes begin at 1 in WPILib for C++ and Java\n");
            return false;
        }
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        if ((this.m_joystickButtonsReleased[stick].m_buttons & 1 << button - 1) != 0) {
            this.m_joystickButtonsReleased[stick].m_buttons &= ~(1 << button - 1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStickAxis(int stick, int axis) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (axis < 0 || axis >= HAL.kMaxJoystickAxes) {
            throw new RuntimeException("Joystick axis is out of range");
        }
        boolean error = false;
        double retVal = 0.0;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (axis >= this.m_joystickAxes[stick].m_count) {
                error = true;
                retVal = 0.0;
            } else {
                retVal = this.m_joystickAxes[stick].m_axes[axis];
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick axis " + axis + " on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickPOV(int stick, int pov) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        if (pov < 0 || pov >= HAL.kMaxJoystickPOVs) {
            throw new RuntimeException("Joystick POV is out of range");
        }
        boolean error = false;
        int retVal = -1;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (pov >= this.m_joystickPOVs[stick].m_count) {
                error = true;
                retVal = -1;
            } else {
                retVal = this.m_joystickPOVs[stick].m_povs[pov];
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick POV " + pov + " on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickButtons(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-3");
        }
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_joystickButtons[stick].m_buttons;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickAxisCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_joystickAxes[stick].m_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickPOVCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_joystickPOVs[stick].m_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStickButtonCount(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_joystickButtons[stick].m_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJoystickIsXbox(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        boolean error = false;
        boolean retVal = false;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (1 > this.m_joystickButtons[stick].m_count && 1 > this.m_joystickAxes[stick].m_count) {
                error = true;
                retVal = false;
            } else if (HAL.getJoystickIsXbox((byte)stick) == 1) {
                retVal = true;
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJoystickType(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        boolean error = false;
        int retVal = -1;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (1 > this.m_joystickButtons[stick].m_count && 1 > this.m_joystickAxes[stick].m_count) {
                error = true;
                retVal = -1;
            } else {
                retVal = HAL.getJoystickType((byte)stick);
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJoystickName(int stick) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        boolean error = false;
        String retVal = "";
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            if (1 > this.m_joystickButtons[stick].m_count && 1 > this.m_joystickAxes[stick].m_count) {
                error = true;
                retVal = "";
            } else {
                retVal = HAL.getJoystickName((byte)stick);
            }
        }
        if (error) {
            this.reportJoystickUnpluggedWarning("Joystick on port " + stick + " not available, check if controller is plugged in");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJoystickAxisType(int stick, int axis) {
        if (stick < 0 || stick >= 6) {
            throw new RuntimeException("Joystick index is out of range, should be 0-5");
        }
        int retVal = -1;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            retVal = HAL.getJoystickAxisType((byte)stick, (byte)axis);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            this.updateControlWord(false);
            return this.m_controlWordCache.getEnabled() && this.m_controlWordCache.getDSAttached();
        }
    }

    @Override
    public boolean isDisabled() {
        return !this.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutonomous() {
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            this.updateControlWord(false);
            return this.m_controlWordCache.getAutonomous();
        }
    }

    @Override
    public boolean isOperatorControl() {
        return !this.isAutonomous() && !this.isTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTest() {
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            this.updateControlWord(false);
            return this.m_controlWordCache.getTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDSAttached() {
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            this.updateControlWord(false);
            return this.m_controlWordCache.getDSAttached();
        }
    }

    public boolean isNewControlData() {
        return HAL.isNewControlData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFMSAttached() {
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            this.updateControlWord(false);
            return this.m_controlWordCache.getFMSAttached();
        }
    }

    @Deprecated
    public boolean isSysActive() {
        return HAL.getSystemActive();
    }

    @Deprecated
    public boolean isBrownedOut() {
        return HAL.getBrownedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGameSpecificMessage() {
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_matchInfo.gameSpecificMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventName() {
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_matchInfo.eventName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchType getMatchType() {
        int matchType;
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            matchType = this.m_matchInfo.matchType;
        }
        switch (matchType) {
            case 1: {
                return MatchType.Practice;
            }
            case 2: {
                return MatchType.Qualification;
            }
            case 3: {
                return MatchType.Elimination;
            }
        }
        return MatchType.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchNumber() {
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_matchInfo.matchNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReplayNumber() {
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            return this.m_matchInfo.replayNumber;
        }
    }

    public Alliance getAlliance() {
        AllianceStationID allianceStationID = HAL.getAllianceStation();
        if (allianceStationID == null) {
            return Alliance.Invalid;
        }
        switch (allianceStationID) {
            case Red1: 
            case Red2: 
            case Red3: {
                return Alliance.Red;
            }
            case Blue1: 
            case Blue2: 
            case Blue3: {
                return Alliance.Blue;
            }
        }
        return Alliance.Invalid;
    }

    public int getLocation() {
        AllianceStationID allianceStationID = HAL.getAllianceStation();
        if (allianceStationID == null) {
            return 0;
        }
        switch (allianceStationID) {
            case Red1: 
            case Blue1: {
                return 1;
            }
            case Red2: 
            case Blue2: {
                return 2;
            }
            case Red3: 
            case Blue3: {
                return 3;
            }
        }
        return 0;
    }

    public void waitForData() {
        this.waitForData(0.0);
    }

    public boolean waitForData(double timeout) {
        return HAL.waitForDSDataTimeout(timeout);
    }

    public double getMatchTime() {
        return HAL.getMatchTime();
    }

    @Deprecated
    public double getBatteryVoltage() {
        return PowerJNI.getVinVoltage();
    }

    public void InDisabled(boolean entering) {
        this.m_userInDisabled = entering;
    }

    public void InAutonomous(boolean entering) {
        this.m_userInAutonomous = entering;
    }

    public void InOperatorControl(boolean entering) {
        this.m_userInTeleop = entering;
    }

    public void InTest(boolean entering) {
        this.m_userInTest = entering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getData() {
        for (byte stick = 0; stick < 6; stick = (byte)(stick + 1)) {
            this.m_joystickAxesCache[stick].m_count = HAL.getJoystickAxes(stick, this.m_joystickAxesCache[stick].m_axes);
            this.m_joystickPOVsCache[stick].m_count = HAL.getJoystickPOVs(stick, this.m_joystickPOVsCache[stick].m_povs);
            this.m_joystickButtonsCache[stick].m_buttons = HAL.getJoystickButtons(stick, this.m_buttonCountBuffer);
            this.m_joystickButtonsCache[stick].m_count = this.m_buttonCountBuffer.get(0);
        }
        HAL.getMatchInfo(this.m_matchInfoCache);
        this.updateControlWord(true);
        Object object = this.m_cacheDataMutex;
        synchronized (object) {
            for (int i = 0; i < 6; ++i) {
                this.m_joystickButtonsPressed[i].m_buttons |= ~this.m_joystickButtons[i].m_buttons & this.m_joystickButtonsCache[i].m_buttons;
                this.m_joystickButtonsReleased[i].m_buttons |= this.m_joystickButtons[i].m_buttons & ~this.m_joystickButtonsCache[i].m_buttons;
            }
            HALJoystickAxes[] currentAxes = this.m_joystickAxes;
            this.m_joystickAxes = this.m_joystickAxesCache;
            this.m_joystickAxesCache = currentAxes;
            HALJoystickButtons[] currentButtons = this.m_joystickButtons;
            this.m_joystickButtons = this.m_joystickButtonsCache;
            this.m_joystickButtonsCache = currentButtons;
            HALJoystickPOVs[] currentPOVs = this.m_joystickPOVs;
            this.m_joystickPOVs = this.m_joystickPOVsCache;
            this.m_joystickPOVsCache = currentPOVs;
            MatchInfoData currentInfo = this.m_matchInfo;
            this.m_matchInfo = this.m_matchInfoCache;
            this.m_matchInfoCache = currentInfo;
        }
    }

    private void reportJoystickUnpluggedError(String message) {
        double currentTime = Timer.getFPGATimestamp();
        if (currentTime > this.m_nextMessageTime) {
            DriverStation.reportError(message, false);
            this.m_nextMessageTime = currentTime + 1.0;
        }
    }

    private void reportJoystickUnpluggedWarning(String message) {
        double currentTime = Timer.getFPGATimestamp();
        if (currentTime > this.m_nextMessageTime) {
            DriverStation.reportWarning(message, false);
            this.m_nextMessageTime = currentTime + 1.0;
        }
    }

    private void run() {
        int safetyCounter = 0;
        while (this.m_threadKeepAlive) {
            HAL.waitForDSData();
            this.getData();
            if (this.isDisabled()) {
                safetyCounter = 0;
            }
            if (++safetyCounter >= 4) {
                MotorSafetyHelper.checkMotors();
                safetyCounter = 0;
            }
            if (this.m_userInDisabled) {
                HAL.observeUserProgramDisabled();
            }
            if (this.m_userInAutonomous) {
                HAL.observeUserProgramAutonomous();
            }
            if (this.m_userInTeleop) {
                HAL.observeUserProgramTeleop();
            }
            if (!this.m_userInTest) continue;
            HAL.observeUserProgramTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControlWord(boolean force) {
        long now = System.currentTimeMillis();
        Object object = this.m_controlWordMutex;
        synchronized (object) {
            if (now - this.m_lastControlWordUpdate > 50L || force) {
                HAL.getControlWord(this.m_controlWordCache);
                this.m_lastControlWordUpdate = now;
            }
        }
    }

    private static class DriverStationTask
    implements Runnable {
        private DriverStation m_ds;

        DriverStationTask(DriverStation ds) {
            this.m_ds = ds;
        }

        @Override
        public void run() {
            this.m_ds.run();
        }
    }

    public static enum MatchType {
        None,
        Practice,
        Qualification,
        Elimination;

    }

    public static enum Alliance {
        Red,
        Blue,
        Invalid;

    }

    private class HALJoystickPOVs {
        public short[] m_povs;
        public short m_count;

        HALJoystickPOVs(int count) {
            this.m_povs = new short[count];
        }
    }

    private class HALJoystickAxes {
        public float[] m_axes;
        public short m_count;

        HALJoystickAxes(int count) {
            this.m_axes = new float[count];
        }
    }

    private class HALJoystickButtons {
        public int m_buttons;
        public byte m_count;

        private HALJoystickButtons() {
        }
    }
}

