/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class DoubleSolenoid
extends SolenoidBase
implements Sendable {
    private byte m_forwardMask;
    private byte m_reverseMask;
    private int m_forwardHandle = 0;
    private int m_reverseHandle = 0;

    public DoubleSolenoid(int forwardChannel, int reverseChannel) {
        this(SensorBase.getDefaultSolenoidModule(), forwardChannel, reverseChannel);
    }

    public DoubleSolenoid(int moduleNumber, int forwardChannel, int reverseChannel) {
        super(moduleNumber);
        SensorBase.checkSolenoidModule(this.m_moduleNumber);
        SensorBase.checkSolenoidChannel(forwardChannel);
        SensorBase.checkSolenoidChannel(reverseChannel);
        int portHandle = SolenoidJNI.getPortWithModule((byte)this.m_moduleNumber, (byte)forwardChannel);
        this.m_forwardHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        try {
            portHandle = SolenoidJNI.getPortWithModule((byte)this.m_moduleNumber, (byte)reverseChannel);
            this.m_reverseHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        }
        catch (RuntimeException ex) {
            SolenoidJNI.freeSolenoidPort(this.m_forwardHandle);
            this.m_forwardHandle = 0;
            this.m_reverseHandle = 0;
            throw ex;
        }
        this.m_forwardMask = (byte)(1 << forwardChannel);
        this.m_reverseMask = (byte)(1 << reverseChannel);
        HAL.report(34, forwardChannel, this.m_moduleNumber);
        HAL.report(34, reverseChannel, this.m_moduleNumber);
        this.setName("DoubleSolenoid", this.m_moduleNumber, forwardChannel);
    }

    @Override
    public synchronized void free() {
        super.free();
        SolenoidJNI.freeSolenoidPort(this.m_forwardHandle);
        SolenoidJNI.freeSolenoidPort(this.m_reverseHandle);
        super.free();
    }

    public void set(Value value) {
        boolean forward = false;
        boolean reverse = false;
        switch (value) {
            case kOff: {
                forward = false;
                reverse = false;
                break;
            }
            case kForward: {
                forward = true;
                reverse = false;
                break;
            }
            case kReverse: {
                forward = false;
                reverse = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Illegal value: " + (Object)((Object)value)));
            }
        }
        SolenoidJNI.setSolenoid(this.m_forwardHandle, forward);
        SolenoidJNI.setSolenoid(this.m_reverseHandle, reverse);
    }

    public Value get() {
        boolean valueForward = SolenoidJNI.getSolenoid(this.m_forwardHandle);
        boolean valueReverse = SolenoidJNI.getSolenoid(this.m_reverseHandle);
        if (valueForward) {
            return Value.kForward;
        }
        if (valueReverse) {
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public boolean isFwdSolenoidBlackListed() {
        int blackList = this.getPCMSolenoidBlackList();
        return (blackList & this.m_forwardMask) != 0;
    }

    public boolean isRevSolenoidBlackListed() {
        int blackList = this.getPCMSolenoidBlackList();
        return (blackList & this.m_reverseMask) != 0;
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Double Solenoid");
        builder.setSafeState(() -> this.set(Value.kOff));
        builder.addStringProperty("Value", () -> this.get().name().substring(1), value -> {
            if ("Forward".equals(value)) {
                this.set(Value.kForward);
            } else if ("Reverse".equals(value)) {
                this.set(Value.kReverse);
            } else {
                this.set(Value.kOff);
            }
        });
    }

    public static enum Value {
        kOff,
        kForward,
        kReverse;

    }
}

