/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class DigitalOutput
extends SendableBase
implements Sendable {
    private static final int invalidPwmGenerator = 0;
    private int m_pwmGenerator = 0;
    private int m_channel = 0;
    private int m_handle = 0;

    public DigitalOutput(int channel) {
        SensorBase.checkDigitalChannel(channel);
        this.m_channel = channel;
        this.m_handle = DIOJNI.initializeDIOPort(DIOJNI.getPort((byte)channel), false);
        HAL.report(14, channel);
        this.setName("DigitalOutput", channel);
    }

    @Override
    public void free() {
        super.free();
        if (this.m_pwmGenerator != 0) {
            this.disablePWM();
        }
        DIOJNI.freeDIOPort(this.m_handle);
        this.m_handle = 0;
    }

    public void set(boolean value) {
        DIOJNI.setDIO(this.m_handle, (short)(value ? 1 : 0));
    }

    public boolean get() {
        return DIOJNI.getDIO(this.m_handle);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void pulse(double pulseLength) {
        DIOJNI.pulse(this.m_handle, pulseLength);
    }

    public boolean isPulsing() {
        return DIOJNI.isPulsing(this.m_handle);
    }

    public void setPWMRate(double rate) {
        DIOJNI.setDigitalPWMRate(rate);
    }

    public void enablePWM(double initialDutyCycle) {
        if (this.m_pwmGenerator != 0) {
            return;
        }
        this.m_pwmGenerator = DIOJNI.allocateDigitalPWM();
        DIOJNI.setDigitalPWMDutyCycle(this.m_pwmGenerator, initialDutyCycle);
        DIOJNI.setDigitalPWMOutputChannel(this.m_pwmGenerator, this.m_channel);
    }

    public void disablePWM() {
        if (this.m_pwmGenerator == 0) {
            return;
        }
        DIOJNI.setDigitalPWMOutputChannel(this.m_pwmGenerator, SensorBase.kDigitalChannels);
        DIOJNI.freeDigitalPWM(this.m_pwmGenerator);
        this.m_pwmGenerator = 0;
    }

    public void updateDutyCycle(double dutyCycle) {
        if (this.m_pwmGenerator == 0) {
            return;
        }
        DIOJNI.setDigitalPWMDutyCycle(this.m_pwmGenerator, dutyCycle);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Digital Output");
        builder.addBooleanProperty("Value", this::get, this::set);
    }
}

