/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class DigitalInput
extends DigitalSource
implements Sendable {
    private int m_channel = 0;
    private int m_handle = 0;

    public DigitalInput(int channel) {
        DigitalInput.checkDigitalChannel(channel);
        this.m_channel = channel;
        this.m_handle = DIOJNI.initializeDIOPort(DIOJNI.getPort((byte)channel), true);
        HAL.report(13, channel);
        this.setName("DigitalInput", channel);
    }

    @Override
    public void free() {
        super.free();
        if (this.m_interrupt != 0) {
            this.cancelInterrupts();
        }
        DIOJNI.freeDIOPort(this.m_handle);
    }

    public boolean get() {
        return DIOJNI.getDIO(this.m_handle);
    }

    @Override
    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public int getAnalogTriggerTypeForRouting() {
        return 0;
    }

    @Override
    public boolean isAnalogTrigger() {
        return false;
    }

    @Override
    public int getPortHandleForRouting() {
        return this.m_handle;
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Digital Input");
        builder.addBooleanProperty("Value", this::get, null);
    }
}

