/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.Encoder;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.DigitalGlitchFilterJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DigitalGlitchFilter
extends SensorBase {
    private int m_channelIndex = -1;
    private static final Lock m_mutex = new ReentrantLock(true);
    private static final boolean[] m_filterAllocated = new boolean[3];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigitalGlitchFilter() {
        Lock lock = m_mutex;
        synchronized (lock) {
            int index;
            for (index = 0; m_filterAllocated[index] && index < m_filterAllocated.length; ++index) {
            }
            if (index != m_filterAllocated.length) {
                this.m_channelIndex = index;
                DigitalGlitchFilter.m_filterAllocated[index] = true;
                HAL.report(57, this.m_channelIndex, 0);
                this.setName("DigitalGlitchFilter", index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        super.free();
        if (this.m_channelIndex >= 0) {
            Lock lock = m_mutex;
            synchronized (lock) {
                DigitalGlitchFilter.m_filterAllocated[this.m_channelIndex] = false;
            }
            this.m_channelIndex = -1;
        }
    }

    private static void setFilter(DigitalSource input, int channelIndex) {
        if (input != null) {
            if (input.isAnalogTrigger()) {
                throw new IllegalStateException("Analog Triggers not supported for DigitalGlitchFilters");
            }
            DigitalGlitchFilterJNI.setFilterSelect(input.getPortHandleForRouting(), channelIndex);
            int selected = DigitalGlitchFilterJNI.getFilterSelect(input.getPortHandleForRouting());
            if (selected != channelIndex) {
                throw new IllegalStateException("DigitalGlitchFilterJNI.setFilterSelect(" + channelIndex + ") failed -> " + selected);
            }
        }
    }

    public void add(DigitalSource input) {
        DigitalGlitchFilter.setFilter(input, this.m_channelIndex + 1);
    }

    public void add(Encoder input) {
        this.add(input.m_aSource);
        this.add(input.m_bSource);
    }

    public void add(Counter input) {
        this.add(input.m_upSource);
        this.add(input.m_downSource);
    }

    public void remove(DigitalSource input) {
        DigitalGlitchFilter.setFilter(input, 0);
    }

    public void remove(Encoder input) {
        this.remove(input.m_aSource);
        this.remove(input.m_bSource);
    }

    public void remove(Counter input) {
        this.remove(input.m_upSource);
        this.remove(input.m_downSource);
    }

    public void setPeriodCycles(int fpgaCycles) {
        DigitalGlitchFilterJNI.setFilterPeriod(this.m_channelIndex, fpgaCycles);
    }

    public void setPeriodNanoSeconds(long nanoseconds) {
        int fpgaCycles = (int)(nanoseconds * (long)kSystemClockTicksPerMicrosecond / 4L / 1000L);
        this.setPeriodCycles(fpgaCycles);
    }

    public int getPeriodCycles() {
        return DigitalGlitchFilterJNI.getFilterPeriod(this.m_channelIndex);
    }

    public long getPeriodNanoSeconds() {
        int fpgaCycles = this.getPeriodCycles();
        return (long)fpgaCycles * 1000L / (long)(kSystemClockTicksPerMicrosecond / 4);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
    }
}

