/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.CompressorJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class Compressor
extends SendableBase
implements Sendable {
    private int m_compressorHandle;
    private byte m_module;

    public Compressor(int module) {
        this.m_module = (byte)module;
        this.m_compressorHandle = CompressorJNI.initializeCompressor((byte)module);
        HAL.report(10, module);
        this.setName("Compressor", module);
    }

    public Compressor() {
        this(SensorBase.getDefaultSolenoidModule());
    }

    public void start() {
        this.setClosedLoopControl(true);
    }

    public void stop() {
        this.setClosedLoopControl(false);
    }

    public boolean enabled() {
        return CompressorJNI.getCompressor(this.m_compressorHandle);
    }

    public boolean getPressureSwitchValue() {
        return CompressorJNI.getCompressorPressureSwitch(this.m_compressorHandle);
    }

    public double getCompressorCurrent() {
        return CompressorJNI.getCompressorCurrent(this.m_compressorHandle);
    }

    public void setClosedLoopControl(boolean on) {
        CompressorJNI.setCompressorClosedLoopControl(this.m_compressorHandle, on);
    }

    public boolean getClosedLoopControl() {
        return CompressorJNI.getCompressorClosedLoopControl(this.m_compressorHandle);
    }

    public boolean getCompressorCurrentTooHighFault() {
        return CompressorJNI.getCompressorCurrentTooHighFault(this.m_compressorHandle);
    }

    public boolean getCompressorCurrentTooHighStickyFault() {
        return CompressorJNI.getCompressorCurrentTooHighStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorShortedStickyFault() {
        return CompressorJNI.getCompressorShortedStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorShortedFault() {
        return CompressorJNI.getCompressorShortedFault(this.m_compressorHandle);
    }

    public boolean getCompressorNotConnectedStickyFault() {
        return CompressorJNI.getCompressorNotConnectedStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorNotConnectedFault() {
        return CompressorJNI.getCompressorNotConnectedFault(this.m_compressorHandle);
    }

    public void clearAllPCMStickyFaults() {
        CompressorJNI.clearAllPCMStickyFaults(this.m_module);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Compressor");
        builder.addBooleanProperty("Enabled", this::enabled, value -> {
            if (value) {
                this.start();
            } else {
                this.stop();
            }
        });
        builder.addBooleanProperty("Pressure switch", this::getPressureSwitchValue, null);
    }
}

