/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.cscore.AxisCamera;
import edu.wpi.cscore.CameraServerJNI;
import edu.wpi.cscore.CvSink;
import edu.wpi.cscore.CvSource;
import edu.wpi.cscore.MjpegServer;
import edu.wpi.cscore.UsbCamera;
import edu.wpi.cscore.VideoEvent;
import edu.wpi.cscore.VideoException;
import edu.wpi.cscore.VideoListener;
import edu.wpi.cscore.VideoMode;
import edu.wpi.cscore.VideoProperty;
import edu.wpi.cscore.VideoSink;
import edu.wpi.cscore.VideoSource;
import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.wpilibj.hal.HAL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;

public class CameraServer {
    public static final int kBasePort = 1181;
    @Deprecated
    public static final int kSize640x480 = 0;
    @Deprecated
    public static final int kSize320x240 = 1;
    @Deprecated
    public static final int kSize160x120 = 2;
    private static final String kPublishName = "/CameraPublisher";
    private static CameraServer server;
    private AtomicInteger m_defaultUsbDevice = new AtomicInteger();
    private String m_primarySourceName;
    private final Hashtable<String, VideoSource> m_sources = new Hashtable();
    private final Hashtable<String, VideoSink> m_sinks = new Hashtable();
    private final Hashtable<Integer, NetworkTable> m_tables = new Hashtable();
    private final NetworkTable m_publishTable = NetworkTableInstance.getDefault().getTable("/CameraPublisher");
    private final VideoListener m_videoListener;
    private final int m_tableListener;
    private int m_nextPort = 1181;
    private String[] m_addresses = new String[0];

    public static synchronized CameraServer getInstance() {
        if (server == null) {
            server = new CameraServer();
        }
        return server;
    }

    private static String makeSourceValue(int source) {
        switch (VideoSource.getKindFromInt((int)CameraServerJNI.getSourceKind((int)source))) {
            case kUsb: {
                return "usb:" + CameraServerJNI.getUsbCameraPath((int)source);
            }
            case kHttp: {
                String[] urls = CameraServerJNI.getHttpCameraUrls((int)source);
                if (urls.length > 0) {
                    return "ip:" + urls[0];
                }
                return "ip:";
            }
            case kCv: {
                return "usb:";
            }
        }
        return "unknown:";
    }

    private static String makeStreamValue(String address, int port) {
        return "mjpg:http://" + address + ":" + port + "/?action=stream";
    }

    private synchronized String[] getSinkStreamValues(int sink) {
        if (VideoSink.getKindFromInt((int)CameraServerJNI.getSinkKind((int)sink)) != VideoSink.Kind.kMjpeg) {
            return new String[0];
        }
        int port = CameraServerJNI.getMjpegServerPort((int)sink);
        ArrayList<String> values = new ArrayList<String>(this.m_addresses.length + 1);
        String listenAddress = CameraServerJNI.getMjpegServerListenAddress((int)sink);
        if (!listenAddress.isEmpty()) {
            values.add(CameraServer.makeStreamValue(listenAddress, port));
        } else {
            values.add(CameraServer.makeStreamValue(CameraServerJNI.getHostname() + ".local", port));
            for (String addr : this.m_addresses) {
                if (addr.equals("127.0.0.1")) continue;
                values.add(CameraServer.makeStreamValue(addr, port));
            }
        }
        return values.toArray(new String[0]);
    }

    private synchronized String[] getSourceStreamValues(int source) {
        if (VideoSource.getKindFromInt((int)CameraServerJNI.getSourceKind((int)source)) != VideoSource.Kind.kHttp) {
            return new String[0];
        }
        String[] values = CameraServerJNI.getHttpCameraUrls((int)source);
        for (int j = 0; j < values.length; ++j) {
            values[j] = "mjpg:" + values[j];
        }
        for (VideoSink i : this.m_sinks.values()) {
            int sink = i.getHandle();
            int sinkSource = CameraServerJNI.getSinkSource((int)sink);
            if (source != sinkSource || VideoSink.getKindFromInt((int)CameraServerJNI.getSinkKind((int)sink)) != VideoSink.Kind.kMjpeg) continue;
            String[] finalValues = new String[values.length + 1];
            for (int j = 0; j < values.length; ++j) {
                finalValues[j] = values[j];
            }
            int port = CameraServerJNI.getMjpegServerPort((int)sink);
            finalValues[values.length] = CameraServer.makeStreamValue("172.22.11.2", port);
            return finalValues;
        }
        return values;
    }

    private synchronized void updateStreamValues() {
        for (VideoSink videoSink : this.m_sinks.values()) {
            String[] values;
            NetworkTable table;
            int sink = videoSink.getHandle();
            int source = CameraServerJNI.getSinkSource((int)sink);
            if (source == 0 || (table = this.m_tables.get(source)) == null || VideoSource.getKindFromInt((int)CameraServerJNI.getSourceKind((int)source)) == VideoSource.Kind.kHttp || (values = this.getSinkStreamValues(sink)).length <= 0) continue;
            table.getEntry("streams").setStringArray(values);
        }
        for (VideoSource videoSource : this.m_sources.values()) {
            String[] values;
            int source = videoSource.getHandle();
            NetworkTable table = this.m_tables.get(source);
            if (table == null || (values = this.getSourceStreamValues(source)).length <= 0) continue;
            table.getEntry("streams").setStringArray(values);
        }
    }

    private static String pixelFormatToString(VideoMode.PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case kMJPEG: {
                return "MJPEG";
            }
            case kYUYV: {
                return "YUYV";
            }
            case kRGB565: {
                return "RGB565";
            }
            case kBGR: {
                return "BGR";
            }
            case kGray: {
                return "Gray";
            }
        }
        return "Unknown";
    }

    private static String videoModeToString(VideoMode mode) {
        return mode.width + "x" + mode.height + " " + CameraServer.pixelFormatToString(mode.pixelFormat) + " " + mode.fps + " fps";
    }

    private static String[] getSourceModeValues(int sourceHandle) {
        VideoMode[] modes = CameraServerJNI.enumerateSourceVideoModes((int)sourceHandle);
        String[] modeStrings = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            modeStrings[i] = CameraServer.videoModeToString(modes[i]);
        }
        return modeStrings;
    }

    private static void putSourcePropertyValue(NetworkTable table, VideoEvent event, boolean isNew) {
        String infoName;
        String name;
        if (event.name.startsWith("raw_")) {
            name = "RawProperty/" + event.name;
            infoName = "RawPropertyInfo/" + event.name;
        } else {
            name = "Property/" + event.name;
            infoName = "PropertyInfo/" + event.name;
        }
        NetworkTableEntry entry = table.getEntry(name);
        switch (event.propertyKind) {
            case kBoolean: {
                if (isNew) {
                    entry.setDefaultBoolean(event.value != 0);
                    break;
                }
                entry.setBoolean(event.value != 0);
                break;
            }
            case kInteger: 
            case kEnum: {
                if (isNew) {
                    entry.setDefaultDouble((double)event.value);
                    table.getEntry(infoName + "/min").setDouble((double)CameraServerJNI.getPropertyMin((int)event.propertyHandle));
                    table.getEntry(infoName + "/max").setDouble((double)CameraServerJNI.getPropertyMax((int)event.propertyHandle));
                    table.getEntry(infoName + "/step").setDouble((double)CameraServerJNI.getPropertyStep((int)event.propertyHandle));
                    table.getEntry(infoName + "/default").setDouble((double)CameraServerJNI.getPropertyDefault((int)event.propertyHandle));
                    break;
                }
                entry.setDouble((double)event.value);
                break;
            }
            case kString: {
                if (isNew) {
                    entry.setDefaultString(event.valueStr);
                    break;
                }
                entry.setString(event.valueStr);
                break;
            }
        }
    }

    private CameraServer() {
        this.m_videoListener = new VideoListener(event -> {
            switch (event.kind) {
                case kSourceCreated: {
                    NetworkTable table = this.m_publishTable.getSubTable(event.name);
                    this.m_tables.put(event.sourceHandle, table);
                    table.getEntry("source").setString(CameraServer.makeSourceValue(event.sourceHandle));
                    table.getEntry("description").setString(CameraServerJNI.getSourceDescription((int)event.sourceHandle));
                    table.getEntry("connected").setBoolean(CameraServerJNI.isSourceConnected((int)event.sourceHandle));
                    table.getEntry("streams").setStringArray(this.getSourceStreamValues(event.sourceHandle));
                    try {
                        VideoMode mode = CameraServerJNI.getSourceVideoMode((int)event.sourceHandle);
                        table.getEntry("mode").setDefaultString(CameraServer.videoModeToString(mode));
                        table.getEntry("modes").setStringArray(CameraServer.getSourceModeValues(event.sourceHandle));
                    }
                    catch (VideoException mode) {}
                    break;
                }
                case kSourceDestroyed: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.getEntry("source").setString("");
                    table.getEntry("streams").setStringArray(new String[0]);
                    table.getEntry("modes").setStringArray(new String[0]);
                    break;
                }
                case kSourceConnected: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.getEntry("description").setString(CameraServerJNI.getSourceDescription((int)event.sourceHandle));
                    table.getEntry("connected").setBoolean(true);
                    break;
                }
                case kSourceDisconnected: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.getEntry("connected").setBoolean(false);
                    break;
                }
                case kSourceVideoModesUpdated: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.getEntry("modes").setStringArray(CameraServer.getSourceModeValues(event.sourceHandle));
                    break;
                }
                case kSourceVideoModeChanged: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.getEntry("mode").setString(CameraServer.videoModeToString(event.mode));
                    break;
                }
                case kSourcePropertyCreated: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    CameraServer.putSourcePropertyValue(table, event, true);
                    break;
                }
                case kSourcePropertyValueUpdated: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    CameraServer.putSourcePropertyValue(table, event, false);
                    break;
                }
                case kSourcePropertyChoicesUpdated: {
                    NetworkTable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    String[] choices = CameraServerJNI.getEnumPropertyChoices((int)event.propertyHandle);
                    table.getEntry("PropertyInfo/" + event.name + "/choices").setStringArray(choices);
                    break;
                }
                case kSinkSourceChanged: 
                case kSinkCreated: 
                case kSinkDestroyed: 
                case kNetworkInterfacesChanged: {
                    this.m_addresses = CameraServerJNI.getNetworkInterfaces();
                    this.updateStreamValues();
                    break;
                }
            }
        }, 20479, true);
        this.m_tableListener = NetworkTableInstance.getDefault().addEntryListener("/CameraPublisher/", event -> {
            String propName;
            String relativeKey = event.name.substring(kPublishName.length() + 1);
            int subKeyIndex = relativeKey.indexOf(47);
            if (subKeyIndex == -1) {
                return;
            }
            String sourceName = relativeKey.substring(0, subKeyIndex);
            VideoSource source = this.m_sources.get(sourceName);
            if (source == null) {
                return;
            }
            if ((relativeKey = relativeKey.substring(subKeyIndex + 1)).equals("mode")) {
                event.getEntry().setString(CameraServer.videoModeToString(source.getVideoMode()));
                return;
            }
            if (relativeKey.startsWith("Property/")) {
                propName = relativeKey.substring(9);
            } else if (relativeKey.startsWith("RawProperty/")) {
                propName = relativeKey.substring(12);
            } else {
                return;
            }
            VideoProperty property = source.getProperty(propName);
            switch (property.getKind()) {
                case kNone: {
                    return;
                }
                case kBoolean: {
                    event.getEntry().setBoolean(property.get() != 0);
                    return;
                }
                case kInteger: 
                case kEnum: {
                    event.getEntry().setDouble((double)property.get());
                    return;
                }
                case kString: {
                    event.getEntry().setString(property.getString());
                    return;
                }
            }
        }, 17);
    }

    public UsbCamera startAutomaticCapture() {
        UsbCamera camera = this.startAutomaticCapture(this.m_defaultUsbDevice.getAndIncrement());
        HAL.report(42, camera.getHandle());
        return camera;
    }

    public UsbCamera startAutomaticCapture(int dev) {
        UsbCamera camera = new UsbCamera("USB Camera " + dev, dev);
        this.startAutomaticCapture((VideoSource)camera);
        HAL.report(42, camera.getHandle());
        return camera;
    }

    public UsbCamera startAutomaticCapture(String name, int dev) {
        UsbCamera camera = new UsbCamera(name, dev);
        this.startAutomaticCapture((VideoSource)camera);
        HAL.report(42, camera.getHandle());
        return camera;
    }

    public UsbCamera startAutomaticCapture(String name, String path) {
        UsbCamera camera = new UsbCamera(name, path);
        this.startAutomaticCapture((VideoSource)camera);
        HAL.report(42, camera.getHandle());
        return camera;
    }

    public void startAutomaticCapture(VideoSource camera) {
        this.addCamera(camera);
        MjpegServer server = this.addServer("serve_" + camera.getName());
        server.setSource(camera);
    }

    public AxisCamera addAxisCamera(String host) {
        return this.addAxisCamera("Axis Camera", host);
    }

    public AxisCamera addAxisCamera(String[] hosts) {
        return this.addAxisCamera("Axis Camera", hosts);
    }

    public AxisCamera addAxisCamera(String name, String host) {
        AxisCamera camera = new AxisCamera(name, host);
        this.startAutomaticCapture((VideoSource)camera);
        HAL.report(41, camera.getHandle());
        return camera;
    }

    public AxisCamera addAxisCamera(String name, String[] hosts) {
        AxisCamera camera = new AxisCamera(name, hosts);
        this.startAutomaticCapture((VideoSource)camera);
        HAL.report(41, camera.getHandle());
        return camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo() {
        VideoSource source;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                throw new VideoException("no camera available");
            }
            source = this.m_sources.get(this.m_primarySourceName);
        }
        if (source == null) {
            throw new VideoException("no camera available");
        }
        return this.getVideo(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo(VideoSource camera) {
        String name = "opencv_" + camera.getName();
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            VideoSink sink = this.m_sinks.get(name);
            if (sink != null) {
                VideoSink.Kind kind = sink.getKind();
                if (kind != VideoSink.Kind.kCv) {
                    throw new VideoException("expected OpenCV sink, but got " + kind);
                }
                return (CvSink)sink;
            }
        }
        CvSink newsink = new CvSink(name);
        newsink.setSource(camera);
        this.addServer((VideoSink)newsink);
        return newsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo(String name) {
        VideoSource source;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            source = this.m_sources.get(name);
            if (source == null) {
                throw new VideoException("could not find camera " + name);
            }
        }
        return this.getVideo(source);
    }

    public CvSource putVideo(String name, int width, int height) {
        CvSource source = new CvSource(name, VideoMode.PixelFormat.kMJPEG, width, height, 30);
        this.startAutomaticCapture((VideoSource)source);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MjpegServer addServer(String name) {
        int port;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            port = this.m_nextPort++;
        }
        return this.addServer(name, port);
    }

    public MjpegServer addServer(String name, int port) {
        MjpegServer server = new MjpegServer(name, port);
        this.addServer((VideoSink)server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(VideoSink server) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sinks.put(server.getName(), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sinks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoSink getServer() {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                throw new VideoException("no camera available");
            }
            return this.getServer("serve_" + this.m_primarySourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoSink getServer(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            return this.m_sinks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCamera(VideoSource camera) {
        String name = camera.getName();
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                this.m_primarySourceName = name;
            }
            this.m_sources.put(name, camera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCamera(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sources.remove(name);
        }
    }
}

