/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.AccelerometerJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Accelerometer;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class BuiltInAccelerometer
extends SensorBase
implements Accelerometer,
Sendable {
    public BuiltInAccelerometer(Accelerometer.Range range) {
        this.setRange(range);
        HAL.report(4, 0, 0, "Built-in accelerometer");
        this.setName("BuiltInAccel", 0);
    }

    public BuiltInAccelerometer() {
        this(Accelerometer.Range.k8G);
    }

    @Override
    public void setRange(Accelerometer.Range range) {
        AccelerometerJNI.setAccelerometerActive(false);
        switch (range) {
            case k2G: {
                AccelerometerJNI.setAccelerometerRange(0);
                break;
            }
            case k4G: {
                AccelerometerJNI.setAccelerometerRange(1);
                break;
            }
            case k8G: {
                AccelerometerJNI.setAccelerometerRange(2);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)range) + " range not supported (use k2G, k4G, or k8G)");
            }
        }
        AccelerometerJNI.setAccelerometerActive(true);
    }

    @Override
    public double getX() {
        return AccelerometerJNI.getAccelerometerX();
    }

    @Override
    public double getY() {
        return AccelerometerJNI.getAccelerometerY();
    }

    @Override
    public double getZ() {
        return AccelerometerJNI.getAccelerometerZ();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("3AxisAccelerometer");
        builder.addDoubleProperty("X", this::getX, null);
        builder.addDoubleProperty("Y", this::getY, null);
        builder.addDoubleProperty("Z", this::getZ, null);
    }
}

