/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogTrigger;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.Objects;

public class AnalogTriggerOutput
extends DigitalSource {
    private final AnalogTrigger m_trigger;
    private final AnalogTriggerType m_outputType;

    public AnalogTriggerOutput(AnalogTrigger trigger, AnalogTriggerType outputType) {
        Objects.requireNonNull(trigger, "Analog Trigger given was null");
        Objects.requireNonNull(outputType, "Analog Trigger Type given was null");
        this.m_trigger = trigger;
        this.m_outputType = outputType;
        HAL.report(8, trigger.getIndex(), outputType.value);
    }

    public boolean get() {
        return AnalogJNI.getAnalogTriggerOutput(this.m_trigger.m_port, this.m_outputType.value);
    }

    @Override
    public int getPortHandleForRouting() {
        return this.m_trigger.m_port;
    }

    @Override
    public int getAnalogTriggerTypeForRouting() {
        return this.m_outputType.value;
    }

    @Override
    public int getChannel() {
        return this.m_trigger.m_index;
    }

    @Override
    public boolean isAnalogTrigger() {
        return true;
    }

    @Override
    public void initSendable(SendableBuilder builder) {
    }

    public static enum AnalogTriggerType {
        kInWindow(0),
        kState(1),
        kRisingPulse(2),
        kFallingPulse(3);

        private final int value;

        private AnalogTriggerType(int value) {
            this.value = value;
        }
    }

    public class AnalogTriggerOutputException
    extends RuntimeException {
        public AnalogTriggerOutputException(String message) {
            super(message);
        }
    }
}

