/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.RobotController;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.interfaces.Potentiometer;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class AnalogPotentiometer
extends SensorBase
implements Potentiometer,
Sendable {
    private AnalogInput m_analogInput;
    private boolean m_initAnalogInput;
    private double m_fullRange;
    private double m_offset;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;

    public AnalogPotentiometer(int channel, double fullRange, double offset) {
        this(new AnalogInput(channel), fullRange, offset);
        this.m_initAnalogInput = true;
        this.addChild(this.m_analogInput);
    }

    public AnalogPotentiometer(AnalogInput input, double fullRange, double offset) {
        this.setName("AnalogPotentiometer", input.getChannel());
        this.m_analogInput = input;
        this.m_initAnalogInput = false;
        this.m_fullRange = fullRange;
        this.m_offset = offset;
    }

    public AnalogPotentiometer(int channel, double scale) {
        this(channel, scale, 0.0);
    }

    public AnalogPotentiometer(AnalogInput input, double scale) {
        this(input, scale, 0.0);
    }

    public AnalogPotentiometer(int channel) {
        this(channel, 1.0, 0.0);
    }

    public AnalogPotentiometer(AnalogInput input) {
        this(input, 1.0, 0.0);
    }

    @Override
    public double get() {
        if (this.m_analogInput == null) {
            return this.m_offset;
        }
        return this.m_analogInput.getVoltage() / RobotController.getVoltage5V() * this.m_fullRange + this.m_offset;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        if (!pidSource.equals((Object)PIDSourceType.kDisplacement)) {
            throw new IllegalArgumentException("Only displacement PID is allowed for potentiometers.");
        }
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.get();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        if (this.m_analogInput != null) {
            this.m_analogInput.initSendable(builder);
        }
    }

    @Override
    public void free() {
        super.free();
        if (this.m_initAnalogInput) {
            this.m_analogInput.free();
            this.m_analogInput = null;
            this.m_initAnalogInput = false;
        }
    }
}

