/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SendableBase;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class AnalogOutput
extends SendableBase
implements Sendable {
    private int m_port;
    private int m_channel;

    public AnalogOutput(int channel) {
        SensorBase.checkAnalogOutputChannel(channel);
        this.m_channel = channel;
        int portHandle = AnalogJNI.getPort((byte)channel);
        this.m_port = AnalogJNI.initializeAnalogOutputPort(portHandle);
        HAL.report(49, channel);
        this.setName("AnalogOutput", channel);
    }

    @Override
    public void free() {
        super.free();
        AnalogJNI.freeAnalogOutputPort(this.m_port);
        this.m_port = 0;
        this.m_channel = 0;
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setVoltage(double voltage) {
        AnalogJNI.setAnalogOutput(this.m_port, voltage);
    }

    public double getVoltage() {
        return AnalogJNI.getAnalogOutput(this.m_port);
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Analog Output");
        builder.addDoubleProperty("Value", this::getVoltage, this::setVoltage);
    }
}

