/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import edu.wpi.first.wpilibj.util.AllocationException;

public class AnalogInput
extends SensorBase
implements PIDSource,
Sendable {
    private static final int kAccumulatorSlot = 1;
    int m_port;
    private int m_channel;
    private static final int[] kAccumulatorChannels = new int[]{0, 1};
    private long m_accumulatorOffset;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;

    public AnalogInput(int channel) {
        AnalogInput.checkAnalogInputChannel(channel);
        this.m_channel = channel;
        int portHandle = AnalogJNI.getPort((byte)channel);
        this.m_port = AnalogJNI.initializeAnalogInputPort(portHandle);
        HAL.report(6, channel);
        this.setName("AnalogInput", channel);
    }

    @Override
    public void free() {
        super.free();
        AnalogJNI.freeAnalogInputPort(this.m_port);
        this.m_port = 0;
        this.m_channel = 0;
        this.m_accumulatorOffset = 0L;
    }

    public int getValue() {
        return AnalogJNI.getAnalogValue(this.m_port);
    }

    public int getAverageValue() {
        return AnalogJNI.getAnalogAverageValue(this.m_port);
    }

    public double getVoltage() {
        return AnalogJNI.getAnalogVoltage(this.m_port);
    }

    public double getAverageVoltage() {
        return AnalogJNI.getAnalogAverageVoltage(this.m_port);
    }

    public long getLSBWeight() {
        return AnalogJNI.getAnalogLSBWeight(this.m_port);
    }

    public int getOffset() {
        return AnalogJNI.getAnalogOffset(this.m_port);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setAverageBits(int bits) {
        AnalogJNI.setAnalogAverageBits(this.m_port, bits);
    }

    public int getAverageBits() {
        return AnalogJNI.getAnalogAverageBits(this.m_port);
    }

    public void setOversampleBits(int bits) {
        AnalogJNI.setAnalogOversampleBits(this.m_port, bits);
    }

    public int getOversampleBits() {
        return AnalogJNI.getAnalogOversampleBits(this.m_port);
    }

    public void initAccumulator() {
        if (!this.isAccumulatorChannel()) {
            throw new AllocationException("Accumulators are only available on slot 1 on channels " + kAccumulatorChannels[0] + ", " + kAccumulatorChannels[1]);
        }
        this.m_accumulatorOffset = 0L;
        AnalogJNI.initAccumulator(this.m_port);
    }

    public void setAccumulatorInitialValue(long initialValue) {
        this.m_accumulatorOffset = initialValue;
    }

    public void resetAccumulator() {
        AnalogJNI.resetAccumulator(this.m_port);
        double sampleTime = 1.0 / AnalogInput.getGlobalSampleRate();
        double overSamples = 1 << this.getOversampleBits();
        double averageSamples = 1 << this.getAverageBits();
        Timer.delay(sampleTime * overSamples * averageSamples);
    }

    public void setAccumulatorCenter(int center) {
        AnalogJNI.setAccumulatorCenter(this.m_port, center);
    }

    public void setAccumulatorDeadband(int deadband) {
        AnalogJNI.setAccumulatorDeadband(this.m_port, deadband);
    }

    public long getAccumulatorValue() {
        return AnalogJNI.getAccumulatorValue(this.m_port) + this.m_accumulatorOffset;
    }

    public long getAccumulatorCount() {
        return AnalogJNI.getAccumulatorCount(this.m_port);
    }

    public void getAccumulatorOutput(AccumulatorResult result) {
        if (result == null) {
            throw new IllegalArgumentException("Null parameter `result'");
        }
        if (!this.isAccumulatorChannel()) {
            throw new IllegalArgumentException("Channel " + this.m_channel + " is not an accumulator channel.");
        }
        AnalogJNI.getAccumulatorOutput(this.m_port, result);
        result.value += this.m_accumulatorOffset;
    }

    public boolean isAccumulatorChannel() {
        for (int channel : kAccumulatorChannels) {
            if (this.m_channel != channel) continue;
            return true;
        }
        return false;
    }

    public static void setGlobalSampleRate(double samplesPerSecond) {
        AnalogJNI.setAnalogSampleRate(samplesPerSecond);
    }

    public static double getGlobalSampleRate() {
        return AnalogJNI.getAnalogSampleRate();
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.getAverageVoltage();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Analog Input");
        builder.addDoubleProperty("Value", this::getAverageVoltage, null);
    }
}

