/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;
import java.util.Objects;

public class AnalogAccelerometer
extends SensorBase
implements PIDSource,
Sendable {
    private AnalogInput m_analogChannel;
    private double m_voltsPerG = 1.0;
    private double m_zeroGVoltage = 2.5;
    private boolean m_allocatedChannel;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;

    private void initAccelerometer() {
        HAL.report(4, this.m_analogChannel.getChannel());
        this.setName("Accelerometer", this.m_analogChannel.getChannel());
    }

    public AnalogAccelerometer(int channel) {
        this(new AnalogInput(channel));
        this.m_allocatedChannel = true;
        this.addChild(this.m_analogChannel);
    }

    public AnalogAccelerometer(AnalogInput channel) {
        Objects.requireNonNull(channel, "Analog Channel given was null");
        this.m_allocatedChannel = false;
        this.m_analogChannel = channel;
        this.initAccelerometer();
    }

    @Override
    public void free() {
        super.free();
        if (this.m_analogChannel != null && this.m_allocatedChannel) {
            this.m_analogChannel.free();
        }
        this.m_analogChannel = null;
    }

    public double getAcceleration() {
        if (this.m_analogChannel == null) {
            return 0.0;
        }
        return (this.m_analogChannel.getAverageVoltage() - this.m_zeroGVoltage) / this.m_voltsPerG;
    }

    public void setSensitivity(double sensitivity) {
        this.m_voltsPerG = sensitivity;
    }

    public void setZero(double zero) {
        this.m_zeroGVoltage = zero;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.getAcceleration();
    }

    @Override
    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Accelerometer");
        builder.addDoubleProperty("Value", this::getAcceleration, null);
    }
}

