/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GyroBase;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SPI;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Gyro;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ADXRS450_Gyro
extends GyroBase
implements Gyro,
PIDSource,
Sendable {
    private static final double kSamplePeriod = 5.0E-4;
    private static final double kCalibrationSampleTime = 5.0;
    private static final double kDegreePerSecondPerLSB = 0.0125;
    private static final int kRateRegister = 0;
    private static final int kTemRegister = 2;
    private static final int kLoCSTRegister = 4;
    private static final int kHiCSTRegister = 6;
    private static final int kQuadRegister = 8;
    private static final int kFaultRegister = 10;
    private static final int kPIDRegister = 12;
    private static final int kSNHighRegister = 14;
    private static final int kSNLowRegister = 16;
    private SPI m_spi;

    public ADXRS450_Gyro() {
        this(SPI.Port.kOnboardCS0);
    }

    public ADXRS450_Gyro(SPI.Port port) {
        this.m_spi = new SPI(port);
        this.m_spi.setClockRate(3000000);
        this.m_spi.setMSBFirst();
        this.m_spi.setSampleDataOnRising();
        this.m_spi.setClockActiveHigh();
        this.m_spi.setChipSelectActiveLow();
        if ((this.readRegister(12) & 0xFF00) != 20992) {
            this.m_spi.free();
            this.m_spi = null;
            DriverStation.reportError("could not find ADXRS450 gyro on SPI port " + port.value, false);
            return;
        }
        this.m_spi.initAccumulator(5.0E-4, 0x20000000, 4, 0xC00000E, 0x4000000, 10, 16, true, true);
        this.calibrate();
        HAL.report(54, port.value);
        this.setName("ADXRS450_Gyro", port.value);
    }

    @Override
    public void calibrate() {
        if (this.m_spi == null) {
            return;
        }
        Timer.delay(0.1);
        this.m_spi.setAccumulatorCenter(0);
        this.m_spi.resetAccumulator();
        Timer.delay(5.0);
        this.m_spi.setAccumulatorCenter((int)this.m_spi.getAccumulatorAverage());
        this.m_spi.resetAccumulator();
    }

    private boolean calcParity(int value) {
        boolean parity = false;
        while (value != 0) {
            parity = !parity;
            value &= value - 1;
        }
        return parity;
    }

    private int readRegister(int reg) {
        int cmdhi = 0x8000 | reg << 1;
        boolean parity = this.calcParity(cmdhi);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.put(0, (byte)(cmdhi >> 8));
        buf.put(1, (byte)(cmdhi & 0xFF));
        buf.put(2, (byte)0);
        buf.put(3, (byte)(!parity ? 1 : 0));
        this.m_spi.write(buf, 4);
        this.m_spi.read(false, buf, 4);
        if ((buf.get(0) & 0xE0) == 0) {
            return 0;
        }
        return buf.getInt(0) >> 5 & 0xFFFF;
    }

    @Override
    public void reset() {
        this.m_spi.resetAccumulator();
    }

    @Override
    public void free() {
        super.free();
        if (this.m_spi != null) {
            this.m_spi.free();
            this.m_spi = null;
        }
    }

    @Override
    public double getAngle() {
        if (this.m_spi == null) {
            return 0.0;
        }
        return (double)this.m_spi.getAccumulatorValue() * 0.0125 * 5.0E-4;
    }

    @Override
    public double getRate() {
        if (this.m_spi == null) {
            return 0.0;
        }
        return (double)this.m_spi.getAccumulatorLastValue() * 0.0125;
    }
}

