/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.networktables.ConnectionInfo;
import edu.wpi.first.networktables.ConnectionNotification;
import edu.wpi.first.networktables.EntryInfo;
import edu.wpi.first.networktables.EntryNotification;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.networktables.NetworkTableType;
import edu.wpi.first.networktables.NetworkTableValue;
import edu.wpi.first.networktables.NetworkTablesJNI;
import edu.wpi.first.networktables.PersistentException;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

@Deprecated
public class NetworkTable
implements ITable,
IRemote {
    public static final char PATH_SEPARATOR = '/';
    public static final int DEFAULT_PORT = 1735;
    private static boolean client = false;
    private static boolean enableDS = true;
    private static boolean running = false;
    private static int port = 1735;
    private static String persistentFilename = "networktables.ini";
    private final String path;
    private final String pathWithSep;
    private final NetworkTableInstance inst;
    private final ConcurrentMap<String, NetworkTableEntry> entries = new ConcurrentHashMap<String, NetworkTableEntry>();
    private static final HashMap<IRemoteConnectionListener, ConnectionListenerAdapter> globalConnectionListenerMap = new HashMap();
    private static IRemote staticRemote = new IRemote(){

        @Override
        public void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
            NetworkTable.addGlobalConnectionListener(listener, immediateNotify);
        }

        @Override
        public void removeConnectionListener(IRemoteConnectionListener listener) {
            NetworkTable.removeGlobalConnectionListener(listener);
        }

        @Override
        public boolean isConnected() {
            ConnectionInfo[] conns = NetworkTableInstance.getDefault().getConnections();
            return conns.length > 0;
        }

        @Override
        public boolean isServer() {
            return (NetworkTableInstance.getDefault().getNetworkMode() & 1) != 0;
        }
    };
    private final HashMap<IRemoteConnectionListener, ConnectionListenerAdapter> connectionListenerMap = new HashMap();
    private final HashMap<ITableListener, List<ListenerBase>> oldListenerMap = new HashMap();
    public static final int PERSISTENT = 1;

    private static synchronized void checkInit() {
        if (running) {
            throw new IllegalStateException("Network tables has already been initialized");
        }
    }

    @Deprecated
    public static synchronized void initialize() {
        if (running) {
            NetworkTable.shutdown();
        }
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        if (client) {
            inst.startClient();
            if (enableDS) {
                inst.startDSClient(port);
            }
        } else {
            inst.startServer(persistentFilename, "", port);
        }
        running = true;
    }

    @Deprecated
    public static synchronized void shutdown() {
        if (!running) {
            return;
        }
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        if (client) {
            inst.stopDSClient();
            inst.stopClient();
        } else {
            inst.stopServer();
        }
        running = false;
    }

    @Deprecated
    public static synchronized void setServerMode() {
        if (!client) {
            return;
        }
        NetworkTable.checkInit();
        client = false;
    }

    @Deprecated
    public static synchronized void setClientMode() {
        if (client) {
            return;
        }
        NetworkTable.checkInit();
        client = true;
    }

    @Deprecated
    public static synchronized void setTeam(int team) {
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        inst.setServerTeam(team, port);
        if (enableDS) {
            inst.startDSClient(port);
        }
    }

    @Deprecated
    public static synchronized void setIPAddress(String address) {
        String[] addresses = new String[]{address};
        NetworkTable.setIPAddress(addresses);
    }

    @Deprecated
    public static synchronized void setIPAddress(String[] addresses) {
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        inst.setServer(addresses, port);
        if (addresses.length > 0 && (addresses[0].equals("localhost") || addresses[0].equals("127.0.0.1"))) {
            inst.stopDSClient();
        } else if (enableDS) {
            inst.startDSClient(port);
        }
    }

    @Deprecated
    public static synchronized void setPort(int aport) {
        if (port == aport) {
            return;
        }
        NetworkTable.checkInit();
        port = aport;
    }

    @Deprecated
    public static synchronized void setDSClientEnabled(boolean enabled) {
        NetworkTableInstance inst = NetworkTableInstance.getDefault();
        enableDS = enabled;
        if (enableDS) {
            inst.startDSClient(port);
        } else {
            inst.stopDSClient();
        }
    }

    @Deprecated
    public static synchronized void setPersistentFilename(String filename) {
        if (persistentFilename.equals(filename)) {
            return;
        }
        NetworkTable.checkInit();
        persistentFilename = filename;
    }

    @Deprecated
    public static void setNetworkIdentity(String name) {
        NetworkTableInstance.getDefault().setNetworkIdentity(name);
    }

    public static boolean[] toNative(Boolean[] arr) {
        boolean[] out = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    public static double[] toNative(Number[] arr) {
        double[] out = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i].doubleValue();
        }
        return out;
    }

    public static Boolean[] fromNative(boolean[] arr) {
        Boolean[] out = new Boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    public static Double[] fromNative(double[] arr) {
        Double[] out = new Double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    @Deprecated
    public static synchronized NetworkTable getTable(String key) {
        if (!running) {
            NetworkTable.initialize();
        }
        String theKey = key.isEmpty() || key.equals("/") ? "" : (key.charAt(0) == '/' ? key : '/' + key);
        return new NetworkTable(NetworkTableInstance.getDefault(), theKey);
    }

    NetworkTable(NetworkTableInstance inst, String path) {
        this.path = path;
        this.pathWithSep = path + '/';
        this.inst = inst;
    }

    public String toString() {
        return "NetworkTable: " + this.path;
    }

    private NetworkTableEntry getEntry(String key) {
        NetworkTableEntry entry = (NetworkTableEntry)this.entries.get(key);
        if (entry == null) {
            entry = this.inst.getEntry(this.pathWithSep + key);
            this.entries.putIfAbsent(key, entry);
        }
        return entry;
    }

    @Deprecated
    public static ConnectionInfo[] connections() {
        return NetworkTableInstance.getDefault().getConnections();
    }

    @Override
    @Deprecated
    public boolean isConnected() {
        return this.inst.isConnected();
    }

    @Override
    @Deprecated
    public boolean isServer() {
        return (this.inst.getNetworkMode() & 1) != 0;
    }

    @Deprecated
    public static synchronized void addGlobalConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        ConnectionListenerAdapter adapter = new ConnectionListenerAdapter(staticRemote, listener);
        if (globalConnectionListenerMap.putIfAbsent(listener, adapter) != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        adapter.uid = NetworkTableInstance.getDefault().addConnectionListener(adapter, immediateNotify);
    }

    @Deprecated
    public static synchronized void removeGlobalConnectionListener(IRemoteConnectionListener listener) {
        ConnectionListenerAdapter adapter = globalConnectionListenerMap.remove(listener);
        if (adapter != null) {
            NetworkTableInstance.getDefault().removeConnectionListener(adapter.uid);
        }
    }

    @Override
    @Deprecated
    public synchronized void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        ConnectionListenerAdapter adapter = new ConnectionListenerAdapter(this, listener);
        if (this.connectionListenerMap.putIfAbsent(listener, adapter) != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        adapter.uid = this.inst.addConnectionListener(adapter, immediateNotify);
    }

    @Override
    @Deprecated
    public synchronized void removeConnectionListener(IRemoteConnectionListener listener) {
        ConnectionListenerAdapter adapter = this.connectionListenerMap.get(listener);
        if (adapter != null && this.connectionListenerMap.remove(listener, adapter)) {
            this.inst.removeConnectionListener(adapter.uid);
        }
    }

    @Override
    @Deprecated
    public void addTableListener(ITableListener listener) {
        this.addTableListenerEx(listener, 20);
    }

    @Override
    @Deprecated
    public void addTableListener(ITableListener listener, boolean immediateNotify) {
        int flags = 20;
        if (immediateNotify) {
            flags |= 1;
        }
        this.addTableListenerEx(listener, flags);
    }

    @Override
    @Deprecated
    public synchronized void addTableListenerEx(ITableListener listener, int flags) {
        List<ListenerBase> adapters = this.oldListenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.oldListenerMap.put(listener, adapters);
        }
        OldTableListenerAdapter adapter = new OldTableListenerAdapter(this.path.length() + 1, this, listener);
        adapter.uid = this.inst.addEntryListener(this.pathWithSep, (Consumer<EntryNotification>)adapter, flags);
        adapters.add(adapter);
    }

    @Override
    @Deprecated
    public void addTableListener(String key, ITableListener listener, boolean immediateNotify) {
        int flags = 20;
        if (immediateNotify) {
            flags |= 1;
        }
        this.addTableListenerEx(key, listener, flags);
    }

    @Override
    @Deprecated
    public synchronized void addTableListenerEx(String key, ITableListener listener, int flags) {
        List<ListenerBase> adapters = this.oldListenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.oldListenerMap.put(listener, adapters);
        }
        OldKeyListenerAdapter adapter = new OldKeyListenerAdapter(key, this, listener);
        adapter.uid = this.inst.addEntryListener(this.getEntry(key), (Consumer<EntryNotification>)adapter, flags);
        adapters.add(adapter);
    }

    @Override
    @Deprecated
    public void addSubTableListener(ITableListener listener) {
        this.addSubTableListener(listener, false);
    }

    @Override
    @Deprecated
    public synchronized void addSubTableListener(ITableListener listener, boolean localNotify) {
        List<ListenerBase> adapters = this.oldListenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.oldListenerMap.put(listener, adapters);
        }
        OldSubListenerAdapter adapter = new OldSubListenerAdapter(this.path.length() + 1, this, listener);
        int flags = 5;
        if (localNotify) {
            flags |= 2;
        }
        adapter.uid = this.inst.addEntryListener(this.pathWithSep, (Consumer<EntryNotification>)adapter, flags);
        adapters.add(adapter);
    }

    @Override
    @Deprecated
    public synchronized void removeTableListener(ITableListener listener) {
        List<ListenerBase> adapters = this.oldListenerMap.remove(listener);
        if (adapters != null) {
            for (ListenerBase adapter : adapters) {
                this.inst.removeEntryListener(adapter.uid);
            }
        }
    }

    @Override
    public ITable getSubTable(String key) {
        return new NetworkTable(this.inst, this.pathWithSep + key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.getEntry(key).exists();
    }

    @Override
    public boolean containsSubTable(String key) {
        int[] handles = NetworkTablesJNI.getEntries(this.inst.getHandle(), this.pathWithSep + key + '/', 0);
        return handles.length != 0;
    }

    @Override
    public Set<String> getKeys(int types) {
        HashSet<String> keys = new HashSet<String>();
        int prefixLen = this.path.length() + 1;
        for (EntryInfo info : this.inst.getEntryInfo(this.pathWithSep, types)) {
            String relativeKey = info.name.substring(prefixLen);
            if (relativeKey.indexOf(47) != -1) continue;
            keys.add(relativeKey);
            if (this.entries.get(relativeKey) != null) continue;
            this.entries.putIfAbsent(relativeKey, new NetworkTableEntry(this.inst, info.entry));
        }
        return keys;
    }

    @Override
    public Set<String> getKeys() {
        return this.getKeys(0);
    }

    @Override
    public Set<String> getSubTables() {
        HashSet<String> keys = new HashSet<String>();
        int prefixLen = this.path.length() + 1;
        for (EntryInfo info : this.inst.getEntryInfo(this.pathWithSep, 0)) {
            String relativeKey = info.name.substring(prefixLen);
            int endSubTable = relativeKey.indexOf(47);
            if (endSubTable == -1) continue;
            keys.add(relativeKey.substring(0, endSubTable));
        }
        return keys;
    }

    @Override
    public boolean putNumber(String key, double value) {
        return this.getEntry(key).setNumber(value);
    }

    @Override
    public boolean setDefaultNumber(String key, double defaultValue) {
        return this.getEntry(key).setDefaultDouble(defaultValue);
    }

    @Override
    public double getNumber(String key, double defaultValue) {
        return this.getEntry(key).getDouble(defaultValue);
    }

    @Override
    public boolean putString(String key, String value) {
        return this.getEntry(key).setString(value);
    }

    @Override
    public boolean setDefaultString(String key, String defaultValue) {
        return this.getEntry(key).setDefaultString(defaultValue);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getEntry(key).getString(defaultValue);
    }

    @Override
    public boolean putBoolean(String key, boolean value) {
        return this.getEntry(key).setBoolean(value);
    }

    @Override
    public boolean setDefaultBoolean(String key, boolean defaultValue) {
        return this.getEntry(key).setDefaultBoolean(defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getEntry(key).getBoolean(defaultValue);
    }

    @Override
    public boolean putBooleanArray(String key, boolean[] value) {
        return this.getEntry(key).setBooleanArray(value);
    }

    @Override
    public boolean putBooleanArray(String key, Boolean[] value) {
        return this.getEntry(key).setBooleanArray(value);
    }

    @Override
    public boolean setDefaultBooleanArray(String key, boolean[] defaultValue) {
        return this.getEntry(key).setDefaultBooleanArray(defaultValue);
    }

    @Override
    public boolean setDefaultBooleanArray(String key, Boolean[] defaultValue) {
        return this.getEntry(key).setDefaultBooleanArray(defaultValue);
    }

    @Override
    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        return this.getEntry(key).getBooleanArray(defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String key, Boolean[] defaultValue) {
        return this.getEntry(key).getBooleanArray(defaultValue);
    }

    @Override
    public boolean putNumberArray(String key, double[] value) {
        return this.getEntry(key).setDoubleArray(value);
    }

    @Override
    public boolean putNumberArray(String key, Double[] value) {
        return this.getEntry(key).setNumberArray(value);
    }

    @Override
    public boolean setDefaultNumberArray(String key, double[] defaultValue) {
        return this.getEntry(key).setDefaultDoubleArray(defaultValue);
    }

    @Override
    public boolean setDefaultNumberArray(String key, Double[] defaultValue) {
        return this.getEntry(key).setDefaultNumberArray(defaultValue);
    }

    @Override
    public double[] getNumberArray(String key, double[] defaultValue) {
        return this.getEntry(key).getDoubleArray(defaultValue);
    }

    @Override
    public Double[] getNumberArray(String key, Double[] defaultValue) {
        return this.getEntry(key).getDoubleArray(defaultValue);
    }

    @Override
    public boolean putStringArray(String key, String[] value) {
        return this.getEntry(key).setStringArray(value);
    }

    @Override
    public boolean setDefaultStringArray(String key, String[] defaultValue) {
        return this.getEntry(key).setDefaultStringArray(defaultValue);
    }

    @Override
    public String[] getStringArray(String key, String[] defaultValue) {
        return this.getEntry(key).getStringArray(defaultValue);
    }

    @Override
    public boolean putRaw(String key, byte[] value) {
        return this.getEntry(key).setRaw(value);
    }

    @Override
    public boolean setDefaultRaw(String key, byte[] defaultValue) {
        return this.getEntry(key).setDefaultRaw(defaultValue);
    }

    @Override
    public boolean putRaw(String key, ByteBuffer value, int len) {
        return this.getEntry(key).setRaw(value, len);
    }

    @Override
    public byte[] getRaw(String key, byte[] defaultValue) {
        return this.getEntry(key).getRaw(defaultValue);
    }

    public boolean putValue(String key, NetworkTableValue value) {
        return this.getEntry(key).setValue(value);
    }

    public boolean setDefaultValue(String key, NetworkTableValue defaultValue) {
        return this.getEntry(key).setDefaultValue(defaultValue);
    }

    public NetworkTableValue getValue(String key) {
        return this.getEntry(key).getValue();
    }

    @Override
    @Deprecated
    public boolean putValue(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Boolean) {
            return this.putBoolean(key, (Boolean)value);
        }
        if (value instanceof Number) {
            return this.putDouble(key, ((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return this.putString(key, (String)value);
        }
        if (value instanceof byte[]) {
            return this.putRaw(key, (byte[])value);
        }
        if (value instanceof boolean[]) {
            return this.putBooleanArray(key, (boolean[])value);
        }
        if (value instanceof double[]) {
            return this.putNumberArray(key, (double[])value);
        }
        if (value instanceof Boolean[]) {
            return this.putBooleanArray(key, NetworkTable.toNative((Boolean[])value));
        }
        if (value instanceof Number[]) {
            return this.putNumberArray(key, NetworkTable.toNative((Number[])value));
        }
        if (value instanceof String[]) {
            return this.putStringArray(key, (String[])value);
        }
        if (value instanceof NetworkTableValue) {
            return this.getEntry(key).setValue((NetworkTableValue)value);
        }
        throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " cannot be put into a table");
    }

    @Override
    @Deprecated
    public Object getValue(String key, Object defaultValue) {
        NetworkTableValue value = this.getValue(key);
        if (value.getType() == NetworkTableType.kUnassigned) {
            return defaultValue;
        }
        return value.getValue();
    }

    @Override
    public void setPersistent(String key) {
        this.getEntry(key).setPersistent();
    }

    @Override
    public void clearPersistent(String key) {
        this.getEntry(key).clearPersistent();
    }

    @Override
    public boolean isPersistent(String key) {
        return this.getEntry(key).isPersistent();
    }

    @Override
    public void setFlags(String key, int flags) {
        this.getEntry(key).setFlags(flags);
    }

    @Override
    public void clearFlags(String key, int flags) {
        this.getEntry(key).clearFlags(flags);
    }

    @Override
    public int getFlags(String key) {
        return this.getEntry(key).getFlags();
    }

    @Override
    public void delete(String key) {
        this.getEntry(key).delete();
    }

    @Deprecated
    public static void globalDeleteAll() {
        NetworkTableInstance.getDefault().deleteAllEntries();
    }

    @Deprecated
    public static void flush() {
        NetworkTableInstance.getDefault().flush();
    }

    @Deprecated
    public static void setUpdateRate(double interval) {
        NetworkTableInstance.getDefault().setUpdateRate(interval);
    }

    @Deprecated
    public static void savePersistent(String filename) throws PersistentException {
        NetworkTableInstance.getDefault().savePersistent(filename);
    }

    @Deprecated
    public static String[] loadPersistent(String filename) throws PersistentException {
        return NetworkTableInstance.getDefault().loadPersistent(filename);
    }

    @Override
    @Deprecated
    public boolean putDouble(String key, double value) {
        return this.putNumber(key, value);
    }

    @Override
    @Deprecated
    public double getDouble(String key, double defaultValue) {
        return this.getNumber(key, defaultValue);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkTable)) {
            return false;
        }
        NetworkTable other = (NetworkTable)o;
        return this.inst.equals(other.inst) && this.path.equals(other.path);
    }

    public int hashCode() {
        return Objects.hash(this.inst, this.path);
    }

    private class OldSubListenerAdapter
    extends ListenerBase
    implements Consumer<EntryNotification> {
        private final int prefixLen;
        private final ITable targetSource;
        private final ITableListener targetListener;
        private final Set<String> notifiedTables;

        public OldSubListenerAdapter(int prefixLen, ITable targetSource, ITableListener targetListener) {
            this.notifiedTables = new HashSet<String>();
            this.prefixLen = prefixLen;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void accept(EntryNotification event) {
            String relativeKey = event.name.substring(this.prefixLen);
            int endSubTable = relativeKey.indexOf(47);
            if (endSubTable == -1) {
                return;
            }
            String subTableKey = relativeKey.substring(0, endSubTable);
            if (this.notifiedTables.contains(subTableKey)) {
                return;
            }
            this.notifiedTables.add(subTableKey);
            this.targetListener.valueChangedEx(this.targetSource, subTableKey, this.targetSource.getSubTable(subTableKey), event.flags);
        }
    }

    private class OldKeyListenerAdapter
    extends ListenerBase
    implements Consumer<EntryNotification> {
        private final String relativeKey;
        private final ITable targetSource;
        private final ITableListener targetListener;

        public OldKeyListenerAdapter(String relativeKey, ITable targetSource, ITableListener targetListener) {
            this.relativeKey = relativeKey;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void accept(EntryNotification event) {
            this.targetListener.valueChangedEx(this.targetSource, this.relativeKey, event.value.getValue(), event.flags);
        }
    }

    private class OldTableListenerAdapter
    extends ListenerBase
    implements Consumer<EntryNotification> {
        private final int prefixLen;
        private final ITable targetSource;
        private final ITableListener targetListener;

        public OldTableListenerAdapter(int prefixLen, ITable targetSource, ITableListener targetListener) {
            this.prefixLen = prefixLen;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void accept(EntryNotification event) {
            String relativeKey = event.name.substring(this.prefixLen);
            if (relativeKey.indexOf(47) != -1) {
                return;
            }
            this.targetListener.valueChangedEx(this.targetSource, relativeKey, event.value.getValue(), event.flags);
        }
    }

    private static class ListenerBase {
        public int uid;

        private ListenerBase() {
        }
    }

    private static class ConnectionListenerAdapter
    implements Consumer<ConnectionNotification> {
        public int uid;
        private final IRemote targetSource;
        private final IRemoteConnectionListener targetListener;

        public ConnectionListenerAdapter(IRemote targetSource, IRemoteConnectionListener targetListener) {
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void accept(ConnectionNotification event) {
            if (event.connected) {
                this.targetListener.connectedEx(this.targetSource, event.conn);
            } else {
                this.targetListener.disconnectedEx(this.targetSource, event.conn);
            }
        }
    }
}

