/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.networktables;

import edu.wpi.first.networktables.ConnectionInfo;
import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.networktables.NetworkTablesJNI;

public final class RpcAnswer {
    public final int entry;
    public int call;
    public final String name;
    public final String params;
    public final ConnectionInfo conn;
    static final byte[] emptyResponse = new byte[0];
    private final NetworkTableInstance inst;
    NetworkTableEntry entryObject;

    public RpcAnswer(NetworkTableInstance inst, int entry, int call, String name, String params, ConnectionInfo conn) {
        this.inst = inst;
        this.entry = entry;
        this.call = call;
        this.name = name;
        this.params = params;
        this.conn = conn;
    }

    public synchronized void free() {
        if (this.call != 0) {
            this.postResponse(emptyResponse);
        }
    }

    public boolean isValid() {
        return this.call != 0;
    }

    public void postResponse(byte[] result) {
        NetworkTablesJNI.postRpcResponse(this.entry, this.call, result);
        this.call = 0;
    }

    NetworkTableEntry getEntry() {
        if (this.entryObject == null) {
            this.entryObject = new NetworkTableEntry(this.inst, this.entry);
        }
        return this.entryObject;
    }
}

