/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.sensors;

import com.ctre.phoenix.ErrorCode;
import com.ctre.phoenix.ParamEnum;
import com.ctre.phoenix.motorcontrol.can.TalonSRX;
import com.ctre.phoenix.sensors.PigeonIMU_ControlFrame;
import com.ctre.phoenix.sensors.PigeonIMU_Faults;
import com.ctre.phoenix.sensors.PigeonIMU_StatusFrame;
import com.ctre.phoenix.sensors.PigeonIMU_StickyFaults;
import com.ctre.phoenix.sensors.PigeonImuJNI;
import edu.wpi.first.wpilibj.hal.HAL;

public class PigeonIMU {
    private long m_handle;
    private int m_deviceNumber = 0;
    private double[] _generalStatus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] _fusionStatus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public PigeonIMU(int deviceNumber) {
        this.m_handle = PigeonImuJNI.JNI_new_PigeonImu(deviceNumber);
        this.m_deviceNumber = deviceNumber;
        HAL.report((int)61, (int)(this.m_deviceNumber + 1));
    }

    public PigeonIMU(TalonSRX talonSrx) {
        this.m_deviceNumber = talonSrx.getDeviceID();
        this.m_handle = PigeonImuJNI.JNI_new_PigeonImu_Talon(this.m_deviceNumber);
        HAL.report((int)61, (int)(this.m_deviceNumber + 1));
        HAL.report((int)64, (int)(this.m_deviceNumber + 1));
    }

    public ErrorCode setYaw(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetYaw(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode addYaw(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_AddYaw(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setYawToCompass(int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetYawToCompass(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setFusedHeading(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetFusedHeading(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode addFusedHeading(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_AddFusedHeading(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setFusedHeadingToCompass(int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetFusedHeadingToCompass(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setAccumZAngle(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetAccumZAngle(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configTemperatureCompensationEnable(boolean bTempCompEnable, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_ConfigTemperatureCompensationEnable(this.m_handle, bTempCompEnable ? 1 : 0, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setCompassDeclination(double angleDegOffset, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetCompassDeclination(this.m_handle, angleDegOffset, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setCompassAngle(double angleDeg, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetCompassAngle(this.m_handle, angleDeg, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode enterCalibrationMode(CalibrationMode calMode, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_EnterCalibrationMode(this.m_handle, calMode.value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getGeneralStatus(GeneralStatus toFill) {
        int retval = PigeonImuJNI.JNI_GetGeneralStatus(this.m_handle, this._generalStatus);
        toFill.state = PigeonState.valueOf((int)this._generalStatus[0]);
        toFill.currentMode = CalibrationMode.valueOf((int)this._generalStatus[1]);
        toFill.calibrationError = (int)this._generalStatus[2];
        toFill.bCalIsBooting = this._generalStatus[3] != 0.0;
        toFill.tempC = this._generalStatus[4];
        toFill.upTimeSec = (int)this._generalStatus[5];
        toFill.noMotionBiasCount = (int)this._generalStatus[6];
        toFill.tempCompensationCount = (int)this._generalStatus[7];
        toFill.lastError = ErrorCode.valueOf(retval);
        return toFill.lastError;
    }

    public ErrorCode getLastError() {
        int retval = PigeonImuJNI.JNI_GetLastError(this.m_handle);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode get6dQuaternion(double[] wxyz) {
        int retval = PigeonImuJNI.JNI_Get6dQuaternion(this.m_handle, wxyz);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getYawPitchRoll(double[] ypr_deg) {
        int retval = PigeonImuJNI.JNI_GetYawPitchRoll(this.m_handle, ypr_deg);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getAccumGyro(double[] xyz_deg) {
        int retval = PigeonImuJNI.JNI_GetAccumGyro(this.m_handle, xyz_deg);
        return ErrorCode.valueOf(retval);
    }

    public double getAbsoluteCompassHeading() {
        double retval = PigeonImuJNI.JNI_GetAbsoluteCompassHeading(this.m_handle);
        return retval;
    }

    public double getCompassHeading() {
        double retval = PigeonImuJNI.JNI_GetCompassHeading(this.m_handle);
        return retval;
    }

    public double getCompassFieldStrength() {
        double retval = PigeonImuJNI.JNI_GetCompassFieldStrength(this.m_handle);
        return retval;
    }

    public double getTemp() {
        double retval = PigeonImuJNI.JNI_GetTemp(this.m_handle);
        return retval;
    }

    public PigeonState getState() {
        int retval = PigeonImuJNI.JNI_GetState(this.m_handle);
        return PigeonState.valueOf(retval);
    }

    public int getUpTime() {
        int retval = PigeonImuJNI.JNI_GetUpTime(this.m_handle);
        return retval;
    }

    public ErrorCode getRawMagnetometer(short[] rm_xyz) {
        int retval = PigeonImuJNI.JNI_GetRawMagnetometer(this.m_handle, rm_xyz);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getBiasedMagnetometer(short[] bm_xyz) {
        int retval = PigeonImuJNI.JNI_GetBiasedMagnetometer(this.m_handle, bm_xyz);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getBiasedAccelerometer(short[] ba_xyz) {
        int retval = PigeonImuJNI.JNI_GetBiasedAccelerometer(this.m_handle, ba_xyz);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getRawGyro(double[] xyz_dps) {
        int retval = PigeonImuJNI.JNI_GetRawGyro(this.m_handle, xyz_dps);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getAccelerometerAngles(double[] tiltAngles) {
        int retval = PigeonImuJNI.JNI_GetAccelerometerAngles(this.m_handle, tiltAngles);
        return ErrorCode.valueOf(retval);
    }

    public double getFusedHeading(FusionStatus toFill) {
        int errorCode = PigeonImuJNI.JNI_GetFusedHeading(this.m_handle, this._fusionStatus);
        if (toFill != null) {
            toFill.heading = this._fusionStatus[0];
            toFill.bIsFusing = this._fusionStatus[1] != 0.0;
            toFill.bIsValid = this._fusionStatus[2] != 0.0;
            toFill.lastError = ErrorCode.valueOf(errorCode);
        }
        return this._fusionStatus[0];
    }

    public double getFusedHeading() {
        PigeonImuJNI.JNI_GetFusedHeading(this.m_handle, this._fusionStatus);
        return this._fusionStatus[0];
    }

    public int getFirmwareVersion() {
        int k = PigeonImuJNI.JNI_GetFirmwareVersion(this.m_handle);
        return k;
    }

    public boolean hasResetOccurred() {
        boolean k = PigeonImuJNI.JNI_HasResetOccurred(this.m_handle);
        return k;
    }

    public ErrorCode configSetCustomParam(int newValue, int paramIndex, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_ConfigSetCustomParam(this.m_handle, newValue, paramIndex, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int configGetCustomParam(int paramIndex, int timoutMs) {
        int retval = PigeonImuJNI.JNI_ConfigGetCustomParam(this.m_handle, paramIndex, timoutMs);
        return retval;
    }

    public ErrorCode configSetParameter(ParamEnum param, double value, int subValue, int ordinal, int timeoutMs) {
        return this.configSetParameter(param.value, value, subValue, ordinal, timeoutMs);
    }

    public ErrorCode configSetParameter(int param, double value, int subValue, int ordinal, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_ConfigSetParameter(this.m_handle, param, value, subValue, ordinal, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public double configGetParameter(ParamEnum param, int ordinal, int timeoutMs) {
        return this.configGetParameter(param.value, ordinal, timeoutMs);
    }

    public double configGetParameter(int param, int ordinal, int timeoutMs) {
        return PigeonImuJNI.JNI_ConfigGetParameter(this.m_handle, param, ordinal, timeoutMs);
    }

    public ErrorCode setStatusFramePeriod(PigeonIMU_StatusFrame statusFrame, int periodMs, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetStatusFramePeriod(this.m_handle, statusFrame.value, periodMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setStatusFramePeriod(int statusFrame, int periodMs, int timeoutMs) {
        int retval = PigeonImuJNI.JNI_SetStatusFramePeriod(this.m_handle, statusFrame, periodMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getStatusFramePeriod(PigeonIMU_StatusFrame frame, int timeoutMs) {
        return PigeonImuJNI.JNI_GetStatusFramePeriod(this.m_handle, frame.value, timeoutMs);
    }

    public ErrorCode setControlFramePeriod(PigeonIMU_ControlFrame frame, int periodMs) {
        int retval = PigeonImuJNI.JNI_SetControlFramePeriod(this.m_handle, frame.value, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setControlFramePeriod(int frame, int periodMs) {
        int retval = PigeonImuJNI.JNI_SetControlFramePeriod(this.m_handle, frame, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode getFaults(PigeonIMU_Faults toFill) {
        int bits = PigeonImuJNI.JNI_GetFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    public ErrorCode getStickyFaults(PigeonIMU_StickyFaults toFill) {
        int bits = PigeonImuJNI.JNI_GetStickyFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    public ErrorCode clearStickyFaults(int timeoutMs) {
        int retval = PigeonImuJNI.JNI_ClearStickyFaults(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getDeviceID() {
        return this.m_deviceNumber;
    }

    public static class GeneralStatus {
        public PigeonState state;
        public CalibrationMode currentMode;
        public int calibrationError;
        public boolean bCalIsBooting;
        public double tempC;
        public int upTimeSec;
        public int noMotionBiasCount;
        public int tempCompensationCount;
        public ErrorCode lastError;

        public String toString() {
            String description;
            if (this.lastError != ErrorCode.OK) {
                description = "Status frame was not received, check wired connections and web-based config.";
            } else if (this.bCalIsBooting) {
                description = "Pigeon is boot-caling to properly bias accel and gyro.  Do not move Pigeon.  When finished biasing, calibration mode will start.";
            } else if (this.state == PigeonState.UserCalibration) {
                switch (this.currentMode) {
                    case BootTareGyroAccel: {
                        description = "Boot-Calibration: Gyro and Accelerometer are being biased.";
                        break;
                    }
                    case Temperature: {
                        description = "Temperature-Calibration: Pigeon is collecting temp data and will finish when temp range is reached. \n";
                        description = description + "Do not move Pigeon.";
                        break;
                    }
                    case Magnetometer12Pt: {
                        description = "Magnetometer Level 1 calibration: Orient the Pigeon PCB in the 12 positions documented in the User's Manual.";
                        break;
                    }
                    case Magnetometer360: {
                        description = "Magnetometer Level 2 calibration: Spin robot slowly in 360' fashion.  ";
                        break;
                    }
                    case Accelerometer: {
                        description = "Accelerometer Calibration: Pigeon PCB must be placed on a level source.  Follow User's Guide for how to level surfacee.  ";
                        break;
                    }
                    default: {
                        description = "Unknown status";
                        break;
                    }
                }
            } else if (this.state == PigeonState.Ready) {
                description = "Pigeon is running normally.  Last CAL error code was ";
                description = description + Integer.toString(this.calibrationError);
                description = description + ".";
            } else {
                description = this.state == PigeonState.Initializing ? "Pigeon is boot-caling to properly bias accel and gyro.  Do not move Pigeon." : "Not enough data to determine status.";
            }
            return description;
        }
    }

    public static enum PigeonState {
        NoComm(0),
        Initializing(1),
        Ready(2),
        UserCalibration(3),
        Unknown(-1);

        public final int value;

        private PigeonState(int initValue) {
            this.value = initValue;
        }

        public static PigeonState valueOf(int value) {
            for (PigeonState e : PigeonState.values()) {
                if (e.value != value) continue;
                return e;
            }
            return Unknown;
        }
    }

    public static enum CalibrationMode {
        BootTareGyroAccel(0),
        Temperature(1),
        Magnetometer12Pt(2),
        Magnetometer360(3),
        Accelerometer(5),
        Unknown(-1);

        public final int value;

        private CalibrationMode(int initValue) {
            this.value = initValue;
        }

        public static CalibrationMode valueOf(int value) {
            for (CalibrationMode e : CalibrationMode.values()) {
                if (e.value != value) continue;
                return e;
            }
            return Unknown;
        }
    }

    public static class FusionStatus {
        public double heading;
        public boolean bIsValid;
        public boolean bIsFusing;
        public ErrorCode lastError;

        public String toString() {
            String description = this.lastError != ErrorCode.OK ? "Could not receive status frame.  Check wiring and web-config." : (!this.bIsValid ? "Fused Heading is not valid." : (!this.bIsFusing ? "Fused Heading is valid." : "Fused Heading is valid and is fusing compass."));
            return description;
        }
    }
}

