/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.schedulers;

import com.ctre.phoenix.ILoopable;
import java.util.ArrayList;

public class SequentialScheduler
implements ILoopable {
    boolean _running = false;
    ArrayList<ILoopable> _loops = new ArrayList();
    int _periodMs;
    int _idx;
    boolean _iterated = false;

    public SequentialScheduler(int periodMs) {
        this._periodMs = periodMs;
    }

    public void add(ILoopable aLoop) {
        this._loops.add(aLoop);
    }

    public ILoopable getCurrent() {
        return null;
    }

    public void removeAll() {
        this._loops.clear();
    }

    public void start() {
        this._idx = 0;
        if (this._loops.size() > 0) {
            this._loops.get(0).onStart();
        }
        this._running = true;
    }

    public void stop() {
        for (int i = 0; i < this._loops.size(); ++i) {
            this._loops.get(i).onStop();
        }
        this._running = false;
    }

    public void process() {
        this._iterated = false;
        if (this._idx < this._loops.size()) {
            if (this._running) {
                ILoopable loop = this._loops.get(this._idx);
                loop.onLoop();
                if (loop.isDone()) {
                    this._iterated = true;
                    ++this._idx;
                    if (this._idx < this._loops.size()) {
                        this._loops.get(this._idx).onStart();
                    }
                }
            }
        } else {
            this._running = false;
        }
    }

    public boolean iterated() {
        return this._iterated;
    }

    @Override
    public void onStart() {
        this.start();
    }

    @Override
    public void onLoop() {
        this.process();
    }

    @Override
    public boolean isDone() {
        return !this._running;
    }

    @Override
    public void onStop() {
        this.stop();
    }
}

