/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.schedulers;

import com.ctre.phoenix.ILoopable;
import java.util.ArrayList;

public class ConcurrentScheduler
implements ILoopable {
    ArrayList<ILoopable> _loops = new ArrayList();
    ArrayList<Boolean> _enabs = new ArrayList();

    public void add(ILoopable aLoop, boolean enable) {
        this._loops.add(aLoop);
        this._enabs.add(enable);
    }

    public void add(ILoopable aLoop) {
        this.add(aLoop, true);
    }

    public void removeAll() {
        this._loops.clear();
        this._enabs.clear();
    }

    public void start(ILoopable toStart) {
        for (int i = 0; i < this._loops.size(); ++i) {
            ILoopable lp = this._loops.get(i);
            if (lp != toStart) continue;
            this._enabs.set(i, true);
            lp.onStart();
            return;
        }
    }

    public void stop(ILoopable toStop) {
        for (int i = 0; i < this._loops.size(); ++i) {
            ILoopable lp = this._loops.get(i);
            if (lp != toStop) continue;
            this._enabs.set(i, false);
            lp.onStop();
            return;
        }
    }

    public void startAll() {
        for (ILoopable loop : this._loops) {
            loop.onStart();
        }
        for (int i = 0; i < this._enabs.size(); ++i) {
            this._enabs.set(i, true);
        }
    }

    public void stopAll() {
        for (ILoopable loop : this._loops) {
            loop.onStop();
        }
        for (int i = 0; i < this._enabs.size(); ++i) {
            this._enabs.set(i, false);
        }
    }

    public void process() {
        for (int i = 0; i < this._loops.size(); ++i) {
            ILoopable loop = this._loops.get(i);
            boolean en = this._enabs.get(i);
            if (!en) continue;
            loop.onLoop();
        }
    }

    @Override
    public void onStart() {
        this.startAll();
    }

    @Override
    public void onLoop() {
        this.process();
    }

    @Override
    public void onStop() {
        this.stopAll();
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

