/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.motorcontrol.can;

import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.can.TalonSRX;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilder;

public class WPI_TalonSRX
extends TalonSRX
implements SpeedController,
Sendable,
MotorSafety {
    private String _description;
    private double _speed;
    private MotorSafetyHelper _safetyHelper;
    private String m_name = "";
    private String m_subsystem = "Ungrouped";

    public WPI_TalonSRX(int deviceNumber) {
        super(deviceNumber);
        HAL.report((int)66, (int)(deviceNumber + 1));
        this._description = "Talon SRX " + deviceNumber;
        this._safetyHelper = new MotorSafetyHelper((MotorSafety)this);
        this._safetyHelper.setExpiration(0.0);
        this._safetyHelper.setSafetyEnabled(false);
        LiveWindow.add((Sendable)this);
        this.setName("Talon SRX ", deviceNumber);
    }

    public void set(double speed) {
        this._speed = speed;
        this.set(ControlMode.PercentOutput, this._speed);
        this._safetyHelper.feed();
    }

    public void pidWrite(double output) {
        this.set(output);
    }

    public double get() {
        return this._speed;
    }

    @Override
    public void set(ControlMode mode, double value) {
        super.set(mode, value);
        this._safetyHelper.feed();
    }

    @Override
    public void set(ControlMode mode, double demand0, double demand1) {
        super.set(mode, demand0, demand1);
        this._safetyHelper.feed();
    }

    @Override
    public void setInverted(boolean isInverted) {
        super.setInverted(isInverted);
    }

    @Override
    public boolean getInverted() {
        return super.getInverted();
    }

    public void disable() {
        this.neutralOutput();
    }

    public void stopMotor() {
        this.neutralOutput();
    }

    public void setExpiration(double timeout) {
        this._safetyHelper.setExpiration(timeout);
    }

    public double getExpiration() {
        return this._safetyHelper.getExpiration();
    }

    public boolean isAlive() {
        return this._safetyHelper.isAlive();
    }

    public boolean isSafetyEnabled() {
        return this._safetyHelper.isSafetyEnabled();
    }

    public void setSafetyEnabled(boolean enabled) {
        this._safetyHelper.setSafetyEnabled(enabled);
    }

    public void free() {
        LiveWindow.remove((Sendable)this);
    }

    public final synchronized String getName() {
        return this.m_name;
    }

    public final synchronized void setName(String name) {
        this.m_name = name;
    }

    protected final void setName(String moduleType, int channel) {
        this.setName(moduleType + "[" + channel + "]");
    }

    protected final void setName(String moduleType, int moduleNumber, int channel) {
        this.setName(moduleType + "[" + moduleNumber + "," + channel + "]");
    }

    public final synchronized String getSubsystem() {
        return this.m_subsystem;
    }

    public final synchronized void setSubsystem(String subsystem) {
        this.m_subsystem = subsystem;
    }

    protected final void addChild(Object child) {
        LiveWindow.addChild((Sendable)this, (Object)child);
    }

    public void initSendable(SendableBuilder builder) {
        builder.setSmartDashboardType("Speed Controller");
        builder.setSafeState(this::stopMotor);
        builder.addDoubleProperty("Value", this::get, this::set);
    }

    public String getDescription() {
        return this._description;
    }
}

