/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.motorcontrol.can;

import com.ctre.phoenix.ErrorCode;
import com.ctre.phoenix.motorcontrol.IMotorControllerEnhanced;
import com.ctre.phoenix.motorcontrol.LimitSwitchNormal;
import com.ctre.phoenix.motorcontrol.LimitSwitchSource;
import com.ctre.phoenix.motorcontrol.StatusFrameEnhanced;
import com.ctre.phoenix.motorcontrol.VelocityMeasPeriod;
import com.ctre.phoenix.motorcontrol.can.BaseMotorController;
import com.ctre.phoenix.motorcontrol.can.MotControllerJNI;
import edu.wpi.first.wpilibj.hal.HAL;

public class TalonSRX
extends BaseMotorController
implements IMotorControllerEnhanced {
    public TalonSRX(int deviceNumber) {
        super(deviceNumber | 0x2040000);
        HAL.report((int)52, (int)(deviceNumber + 1));
    }

    @Override
    public ErrorCode setStatusFramePeriod(StatusFrameEnhanced frame, int periodMs, int timeoutMs) {
        return super.setStatusFramePeriod(frame.value, periodMs, timeoutMs);
    }

    @Override
    public int getStatusFramePeriod(StatusFrameEnhanced frame, int timeoutMs) {
        return super.getStatusFramePeriod(frame, timeoutMs);
    }

    @Override
    public ErrorCode configVelocityMeasurementPeriod(VelocityMeasPeriod period, int timeoutMs) {
        return super.configVelocityMeasurementPeriod(period, timeoutMs);
    }

    @Override
    public ErrorCode configVelocityMeasurementWindow(int windowSize, int timeoutMs) {
        return super.configVelocityMeasurementWindow(windowSize, timeoutMs);
    }

    @Override
    public ErrorCode configForwardLimitSwitchSource(LimitSwitchSource type, LimitSwitchNormal normalOpenOrClose, int timeoutMs) {
        return super.configForwardLimitSwitchSource(type.value, normalOpenOrClose.value, 0, timeoutMs);
    }

    @Override
    public ErrorCode configReverseLimitSwitchSource(LimitSwitchSource type, LimitSwitchNormal normalOpenOrClose, int timeoutMs) {
        return super.configReverseLimitSwitchSource(type.value, normalOpenOrClose.value, 0, timeoutMs);
    }

    @Override
    public ErrorCode configPeakCurrentLimit(int amps, int timeoutMs) {
        int retval = MotControllerJNI.ConfigPeakCurrentLimit(this.m_handle, amps, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configPeakCurrentDuration(int milliseconds, int timeoutMs) {
        int retval = MotControllerJNI.ConfigPeakCurrentDuration(this.m_handle, milliseconds, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configContinuousCurrentLimit(int amps, int timeoutMs) {
        int retval = MotControllerJNI.ConfigContinuousCurrentLimit(this.m_handle, amps, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public void enableCurrentLimit(boolean enable) {
        MotControllerJNI.EnableCurrentLimit(this.m_handle, enable);
    }
}

