/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.motorcontrol.can;

import com.ctre.phoenix.ErrorCode;
import com.ctre.phoenix.ParamEnum;
import com.ctre.phoenix.motion.MotionProfileStatus;
import com.ctre.phoenix.motion.SetValueMotionProfile;
import com.ctre.phoenix.motion.TrajectoryPoint;
import com.ctre.phoenix.motorcontrol.ControlFrame;
import com.ctre.phoenix.motorcontrol.ControlMode;
import com.ctre.phoenix.motorcontrol.DemandType;
import com.ctre.phoenix.motorcontrol.Faults;
import com.ctre.phoenix.motorcontrol.FeedbackDevice;
import com.ctre.phoenix.motorcontrol.FollowerType;
import com.ctre.phoenix.motorcontrol.IMotorController;
import com.ctre.phoenix.motorcontrol.LimitSwitchNormal;
import com.ctre.phoenix.motorcontrol.LimitSwitchSource;
import com.ctre.phoenix.motorcontrol.NeutralMode;
import com.ctre.phoenix.motorcontrol.RemoteFeedbackDevice;
import com.ctre.phoenix.motorcontrol.RemoteLimitSwitchSource;
import com.ctre.phoenix.motorcontrol.RemoteSensorSource;
import com.ctre.phoenix.motorcontrol.SensorCollection;
import com.ctre.phoenix.motorcontrol.SensorTerm;
import com.ctre.phoenix.motorcontrol.StatusFrame;
import com.ctre.phoenix.motorcontrol.StatusFrameEnhanced;
import com.ctre.phoenix.motorcontrol.StickyFaults;
import com.ctre.phoenix.motorcontrol.VelocityMeasPeriod;
import com.ctre.phoenix.motorcontrol.can.MotControllerJNI;

public abstract class BaseMotorController
implements IMotorController {
    private ControlMode m_controlMode = ControlMode.PercentOutput;
    private ControlMode m_sendMode = ControlMode.PercentOutput;
    private int _arbId = 0;
    private boolean _invert = false;
    protected long m_handle;
    private int[] _motionProfStats = new int[11];
    private SensorCollection _sensorColl;

    public BaseMotorController(int arbId) {
        this.m_handle = MotControllerJNI.Create(arbId);
        this._arbId = arbId;
        this._sensorColl = new SensorCollection(this);
    }

    public long getHandle() {
        return this.m_handle;
    }

    @Override
    public int getDeviceID() {
        return MotControllerJNI.GetDeviceNumber(this.m_handle);
    }

    @Override
    public void set(ControlMode mode, double outputValue) {
        this.set(mode, outputValue, DemandType.Neutral, 0.0);
    }

    @Override
    public void set(ControlMode mode, double demand0, double demand1) {
        this.set(mode, demand0, DemandType.Neutral, demand1);
    }

    @Override
    public void set(ControlMode mode, double demand0, DemandType demand1Type, double demand1) {
        this.m_controlMode = mode;
        this.m_sendMode = mode;
        switch (this.m_controlMode) {
            case PercentOutput: {
                MotControllerJNI.Set_4(this.m_handle, this.m_sendMode.value, demand0, demand1, demand1Type.value);
                break;
            }
            case Follower: {
                int work;
                if (0.0 <= demand0 && demand0 <= 62.0) {
                    work = this.getBaseID();
                    work >>= 16;
                    work <<= 8;
                    work |= (int)demand0 & 0xFF;
                } else {
                    work = (int)demand0;
                }
                MotControllerJNI.Set_4(this.m_handle, this.m_sendMode.value, work, demand1, demand1Type.value);
                break;
            }
            case Velocity: 
            case Position: 
            case MotionMagic: 
            case MotionProfile: 
            case MotionProfileArc: {
                MotControllerJNI.Set_4(this.m_handle, this.m_sendMode.value, demand0, demand1, demand1Type.value);
                break;
            }
            case Current: {
                MotControllerJNI.SetDemand(this.m_handle, this.m_sendMode.value, (int)(1000.0 * demand0), 0);
                break;
            }
            default: {
                MotControllerJNI.SetDemand(this.m_handle, this.m_sendMode.value, 0, 0);
            }
        }
    }

    @Override
    public void neutralOutput() {
        this.set(ControlMode.Disabled, 0.0);
    }

    @Override
    public void setNeutralMode(NeutralMode neutralMode) {
        MotControllerJNI.SetNeutralMode(this.m_handle, neutralMode.value);
    }

    public void enableHeadingHold(boolean enable) {
    }

    public void selectDemandType(boolean value) {
    }

    @Override
    public void setSensorPhase(boolean PhaseSensor) {
        MotControllerJNI.SetSensorPhase(this.m_handle, PhaseSensor);
    }

    @Override
    public void setInverted(boolean invert) {
        this._invert = invert;
        MotControllerJNI.SetInverted(this.m_handle, invert);
    }

    @Override
    public boolean getInverted() {
        return this._invert;
    }

    @Override
    public ErrorCode configOpenloopRamp(double secondsFromNeutralToFull, int timeoutMs) {
        int retval = MotControllerJNI.ConfigOpenLoopRamp(this.m_handle, secondsFromNeutralToFull, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configClosedloopRamp(double secondsFromNeutralToFull, int timeoutMs) {
        int retval = MotControllerJNI.ConfigClosedLoopRamp(this.m_handle, secondsFromNeutralToFull, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configPeakOutputForward(double percentOut, int timeoutMs) {
        int retval = MotControllerJNI.ConfigPeakOutputForward(this.m_handle, percentOut, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configPeakOutputReverse(double percentOut, int timeoutMs) {
        int retval = MotControllerJNI.ConfigPeakOutputReverse(this.m_handle, percentOut, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configNominalOutputForward(double percentOut, int timeoutMs) {
        int retval = MotControllerJNI.ConfigNominalOutputForward(this.m_handle, percentOut, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configNominalOutputReverse(double percentOut, int timeoutMs) {
        int retval = MotControllerJNI.ConfigNominalOutputReverse(this.m_handle, percentOut, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configNeutralDeadband(double percentDeadband, int timeoutMs) {
        int retval = MotControllerJNI.ConfigNeutralDeadband(this.m_handle, percentDeadband, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configVoltageCompSaturation(double voltage, int timeoutMs) {
        int retval = MotControllerJNI.ConfigVoltageCompSaturation(this.m_handle, voltage, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configVoltageMeasurementFilter(int filterWindowSamples, int timeoutMs) {
        int retval = MotControllerJNI.ConfigVoltageMeasurementFilter(this.m_handle, filterWindowSamples, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public void enableVoltageCompensation(boolean enable) {
        MotControllerJNI.EnableVoltageCompensation(this.m_handle, enable);
    }

    @Override
    public double getBusVoltage() {
        return MotControllerJNI.GetBusVoltage(this.m_handle);
    }

    @Override
    public double getMotorOutputPercent() {
        return MotControllerJNI.GetMotorOutputPercent(this.m_handle);
    }

    @Override
    public double getMotorOutputVoltage() {
        return this.getBusVoltage() * this.getMotorOutputPercent();
    }

    @Override
    public double getOutputCurrent() {
        return MotControllerJNI.GetOutputCurrent(this.m_handle);
    }

    @Override
    public double getTemperature() {
        return MotControllerJNI.GetTemperature(this.m_handle);
    }

    @Override
    public ErrorCode configSelectedFeedbackSensor(RemoteFeedbackDevice feedbackDevice, int pidIdx, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSelectedFeedbackSensor(this.m_handle, feedbackDevice.value, pidIdx, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configSelectedFeedbackSensor(FeedbackDevice feedbackDevice, int pidIdx, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSelectedFeedbackSensor(this.m_handle, feedbackDevice.value, pidIdx, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configSelectedFeedbackCoefficient(double coefficient, int pidIdx, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSelectedFeedbackCoefficient(this.m_handle, coefficient, pidIdx, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configRemoteFeedbackFilter(int deviceID, RemoteSensorSource remoteSensorSource, int remoteOrdinal, int timeoutMs) {
        int retval = MotControllerJNI.ConfigRemoteFeedbackFilter(this.m_handle, deviceID, remoteSensorSource.value, remoteOrdinal, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configSensorTerm(SensorTerm sensorTerm, FeedbackDevice feedbackDevice, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSensorTerm(this.m_handle, sensorTerm.value, feedbackDevice.value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public int getSelectedSensorPosition(int pidIdx) {
        return MotControllerJNI.GetSelectedSensorPosition(this.m_handle, pidIdx);
    }

    @Override
    public int getSelectedSensorVelocity(int pidIdx) {
        return MotControllerJNI.GetSelectedSensorVelocity(this.m_handle, pidIdx);
    }

    @Override
    public ErrorCode setSelectedSensorPosition(int sensorPos, int pidIdx, int timeoutMs) {
        int retval = MotControllerJNI.SetSelectedSensorPosition(this.m_handle, sensorPos, pidIdx, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode setControlFramePeriod(ControlFrame frame, int periodMs) {
        int retval = MotControllerJNI.SetControlFramePeriod(this.m_handle, frame.value, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setControlFramePeriod(int frame, int periodMs) {
        int retval = MotControllerJNI.SetControlFramePeriod(this.m_handle, frame, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setStatusFramePeriod(int frameValue, int periodMs, int timeoutMs) {
        int retval = MotControllerJNI.SetStatusFramePeriod(this.m_handle, frameValue, periodMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode setStatusFramePeriod(StatusFrame frame, int periodMs, int timeoutMs) {
        return this.setStatusFramePeriod(frame.value, periodMs, timeoutMs);
    }

    public int getStatusFramePeriod(int frame, int timeoutMs) {
        return MotControllerJNI.GetStatusFramePeriod(this.m_handle, frame, timeoutMs);
    }

    @Override
    public int getStatusFramePeriod(StatusFrame frame, int timeoutMs) {
        return MotControllerJNI.GetStatusFramePeriod(this.m_handle, frame.value, timeoutMs);
    }

    public int getStatusFramePeriod(StatusFrameEnhanced frame, int timeoutMs) {
        return MotControllerJNI.GetStatusFramePeriod(this.m_handle, frame.value, timeoutMs);
    }

    public ErrorCode configVelocityMeasurementPeriod(VelocityMeasPeriod period, int timeoutMs) {
        int retval = MotControllerJNI.ConfigVelocityMeasurementPeriod(this.m_handle, period.value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configVelocityMeasurementWindow(int windowSize, int timeoutMs) {
        int retval = MotControllerJNI.ConfigVelocityMeasurementWindow(this.m_handle, windowSize, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configForwardLimitSwitchSource(RemoteLimitSwitchSource type, LimitSwitchNormal normalOpenOrClose, int deviceID, int timeoutMs) {
        return this.configForwardLimitSwitchSource(type.value, normalOpenOrClose.value, deviceID, timeoutMs);
    }

    @Override
    public ErrorCode configReverseLimitSwitchSource(RemoteLimitSwitchSource type, LimitSwitchNormal normalOpenOrClose, int deviceID, int timeoutMs) {
        int retval = MotControllerJNI.ConfigReverseLimitSwitchSource(this.m_handle, type.value, normalOpenOrClose.value, deviceID, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configForwardLimitSwitchSource(LimitSwitchSource type, LimitSwitchNormal normalOpenOrClose, int timeoutMs) {
        return this.configForwardLimitSwitchSource(type.value, normalOpenOrClose.value, 0, timeoutMs);
    }

    protected ErrorCode configForwardLimitSwitchSource(int typeValue, int normalOpenOrCloseValue, int deviceID, int timeoutMs) {
        int retval = MotControllerJNI.ConfigForwardLimitSwitchSource(this.m_handle, typeValue, normalOpenOrCloseValue, deviceID, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    protected ErrorCode configReverseLimitSwitchSource(int typeValue, int normalOpenOrCloseValue, int deviceID, int timeoutMs) {
        int retval = MotControllerJNI.ConfigReverseLimitSwitchSource(this.m_handle, typeValue, normalOpenOrCloseValue, deviceID, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public void overrideLimitSwitchesEnable(boolean enable) {
        MotControllerJNI.OverrideLimitSwitchesEnable(this.m_handle, enable);
    }

    @Override
    public ErrorCode configForwardSoftLimitThreshold(int forwardSensorLimit, int timeoutMs) {
        int retval = MotControllerJNI.ConfigForwardSoftLimitThreshold(this.m_handle, forwardSensorLimit, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configReverseSoftLimitThreshold(int reverseSensorLimit, int timeoutMs) {
        int retval = MotControllerJNI.ConfigReverseSoftLimitThreshold(this.m_handle, reverseSensorLimit, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configForwardSoftLimitEnable(boolean enable, int timeoutMs) {
        int retval = MotControllerJNI.ConfigForwardSoftLimitEnable(this.m_handle, enable, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configReverseSoftLimitEnable(boolean enable, int timeoutMs) {
        int retval = MotControllerJNI.ConfigReverseSoftLimitEnable(this.m_handle, enable, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public void overrideSoftLimitsEnable(boolean enable) {
        MotControllerJNI.OverrideSoftLimitsEnable(this.m_handle, enable);
    }

    @Override
    public ErrorCode config_kP(int slotIdx, double value, int timeoutMs) {
        int retval = MotControllerJNI.Config_kP(this.m_handle, slotIdx, value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode config_kI(int slotIdx, double value, int timeoutMs) {
        int retval = MotControllerJNI.Config_kI(this.m_handle, slotIdx, value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode config_kD(int slotIdx, double value, int timeoutMs) {
        int retval = MotControllerJNI.Config_kD(this.m_handle, slotIdx, value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode config_kF(int slotIdx, double value, int timeoutMs) {
        int retval = MotControllerJNI.Config_kF(this.m_handle, slotIdx, value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode config_IntegralZone(int slotIdx, int izone, int timeoutMs) {
        int retval = MotControllerJNI.Config_IntegralZone(this.m_handle, slotIdx, izone, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configAllowableClosedloopError(int slotIdx, int allowableClosedLoopError, int timeoutMs) {
        int retval = MotControllerJNI.ConfigAllowableClosedloopError(this.m_handle, slotIdx, allowableClosedLoopError, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configMaxIntegralAccumulator(int slotIdx, double iaccum, int timeoutMs) {
        int retval = MotControllerJNI.ConfigMaxIntegralAccumulator(this.m_handle, slotIdx, iaccum, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configClosedLoopPeakOutput(int slotIdx, double percentOut, int timeoutMs) {
        int retval = MotControllerJNI.ConfigClosedLoopPeakOutput(this.m_handle, slotIdx, percentOut, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configClosedLoopPeriod(int slotIdx, int loopTimeMs, int timeoutMs) {
        int retval = MotControllerJNI.ConfigClosedLoopPeriod(this.m_handle, slotIdx, loopTimeMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configAuxPIDPolarity(boolean invert, int timeoutMs) {
        return this.configSetParameter(ParamEnum.ePIDLoopPolarity, invert ? 1.0 : 0.0, 0, 1, timeoutMs);
    }

    @Override
    public ErrorCode setIntegralAccumulator(double iaccum, int pidIdx, int timeoutMs) {
        int retval = MotControllerJNI.SetIntegralAccumulator(this.m_handle, iaccum, pidIdx, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public int getClosedLoopError(int pidIdx) {
        return MotControllerJNI.GetClosedLoopError(this.m_handle, pidIdx);
    }

    @Override
    public double getIntegralAccumulator(int pidIdx) {
        return MotControllerJNI.GetIntegralAccumulator(this.m_handle, pidIdx);
    }

    @Override
    public double getErrorDerivative(int pidIdx) {
        return MotControllerJNI.GetErrorDerivative(this.m_handle, pidIdx);
    }

    @Override
    public void selectProfileSlot(int slotIdx, int pidIdx) {
        MotControllerJNI.SelectProfileSlot(this.m_handle, slotIdx, pidIdx);
    }

    @Override
    public int getClosedLoopTarget(int pidIdx) {
        return MotControllerJNI.GetClosedLoopTarget(this.m_handle, pidIdx);
    }

    @Override
    public int getActiveTrajectoryPosition() {
        return MotControllerJNI.GetActiveTrajectoryPosition(this.m_handle);
    }

    @Override
    public int getActiveTrajectoryVelocity() {
        return MotControllerJNI.GetActiveTrajectoryVelocity(this.m_handle);
    }

    @Override
    public double getActiveTrajectoryHeading() {
        return MotControllerJNI.GetActiveTrajectoryHeading(this.m_handle);
    }

    @Override
    public ErrorCode configMotionCruiseVelocity(int sensorUnitsPer100ms, int timeoutMs) {
        int retval = MotControllerJNI.ConfigMotionCruiseVelocity(this.m_handle, sensorUnitsPer100ms, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configMotionAcceleration(int sensorUnitsPer100msPerSec, int timeoutMs) {
        int retval = MotControllerJNI.ConfigMotionAcceleration(this.m_handle, sensorUnitsPer100msPerSec, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode clearMotionProfileTrajectories() {
        int retval = MotControllerJNI.ClearMotionProfileTrajectories(this.m_handle);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public int getMotionProfileTopLevelBufferCount() {
        return MotControllerJNI.GetMotionProfileTopLevelBufferCount(this.m_handle);
    }

    @Override
    public ErrorCode pushMotionProfileTrajectory(TrajectoryPoint trajPt) {
        int retval = MotControllerJNI.PushMotionProfileTrajectory2(this.m_handle, trajPt.position, trajPt.velocity, trajPt.auxiliaryPos, trajPt.profileSlotSelect0, trajPt.profileSlotSelect1, trajPt.isLastPoint, trajPt.zeroPos, trajPt.timeDur.value);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public boolean isMotionProfileTopLevelBufferFull() {
        return MotControllerJNI.IsMotionProfileTopLevelBufferFull(this.m_handle);
    }

    @Override
    public void processMotionProfileBuffer() {
        MotControllerJNI.ProcessMotionProfileBuffer(this.m_handle);
    }

    @Override
    public ErrorCode getMotionProfileStatus(MotionProfileStatus statusToFill) {
        int retval = MotControllerJNI.GetMotionProfileStatus2(this.m_handle, this._motionProfStats);
        statusToFill.topBufferRem = this._motionProfStats[0];
        statusToFill.topBufferCnt = this._motionProfStats[1];
        statusToFill.btmBufferCnt = this._motionProfStats[2];
        statusToFill.hasUnderrun = this._motionProfStats[3] != 0;
        statusToFill.isUnderrun = this._motionProfStats[4] != 0;
        statusToFill.activePointValid = this._motionProfStats[5] != 0;
        statusToFill.isLast = this._motionProfStats[6] != 0;
        statusToFill.profileSlotSelect = this._motionProfStats[7];
        statusToFill.outputEnable = SetValueMotionProfile.valueOf(this._motionProfStats[8]);
        statusToFill.timeDurMs = this._motionProfStats[9];
        statusToFill.profileSlotSelect1 = this._motionProfStats[10];
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode clearMotionProfileHasUnderrun(int timeoutMs) {
        int retval = MotControllerJNI.ClearMotionProfileHasUnderrun(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode changeMotionControlFramePeriod(int periodMs) {
        int retval = MotControllerJNI.ChangeMotionControlFramePeriod(this.m_handle, periodMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode configMotionProfileTrajectoryPeriod(int baseTrajDurationMs, int timeoutMs) {
        int retval = MotControllerJNI.ConfigMotionProfileTrajectoryPeriod(this.m_handle, baseTrajDurationMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode getLastError() {
        int retval = MotControllerJNI.GetLastError(this.m_handle);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public ErrorCode getFaults(Faults toFill) {
        int bits = MotControllerJNI.GetFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    @Override
    public ErrorCode getStickyFaults(StickyFaults toFill) {
        int bits = MotControllerJNI.GetStickyFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    @Override
    public ErrorCode clearStickyFaults(int timeoutMs) {
        int retval = MotControllerJNI.ClearStickyFaults(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public int getFirmwareVersion() {
        return MotControllerJNI.GetFirmwareVersion(this.m_handle);
    }

    @Override
    public boolean hasResetOccurred() {
        return MotControllerJNI.HasResetOccurred(this.m_handle);
    }

    @Override
    public ErrorCode configSetCustomParam(int newValue, int paramIndex, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSetCustomParam(this.m_handle, newValue, paramIndex, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public int configGetCustomParam(int paramIndex, int timoutMs) {
        int retval = MotControllerJNI.ConfigGetCustomParam(this.m_handle, paramIndex, timoutMs);
        return retval;
    }

    @Override
    public ErrorCode configSetParameter(ParamEnum param, double value, int subValue, int ordinal, int timeoutMs) {
        return this.configSetParameter(param.value, value, subValue, ordinal, timeoutMs);
    }

    @Override
    public ErrorCode configSetParameter(int param, double value, int subValue, int ordinal, int timeoutMs) {
        int retval = MotControllerJNI.ConfigSetParameter(this.m_handle, param, value, subValue, ordinal, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    @Override
    public double configGetParameter(ParamEnum param, int ordinal, int timeoutMs) {
        return this.configGetParameter(param.value, ordinal, timeoutMs);
    }

    @Override
    public double configGetParameter(int param, int ordinal, int timeoutMs) {
        return MotControllerJNI.ConfigGetParameter(this.m_handle, param, ordinal, timeoutMs);
    }

    @Override
    public int getBaseID() {
        return this._arbId;
    }

    @Override
    public ControlMode getControlMode() {
        return this.m_controlMode;
    }

    public void follow(IMotorController masterToFollow, FollowerType followerType) {
        int id32;
        int id24 = id32 = masterToFollow.getBaseID();
        id24 >>= 16;
        id24 = (short)id24;
        id24 <<= 8;
        this.set(ControlMode.Follower, id24 |= id32 & 0xFF);
        switch (followerType) {
            case PercentOutput: {
                this.set(ControlMode.Follower, id24);
                break;
            }
            case AuxOutput1: {
                this.set(ControlMode.Follower, id24, DemandType.AuxPID, 0.0);
                break;
            }
            default: {
                this.neutralOutput();
            }
        }
    }

    @Override
    public void follow(IMotorController masterToFollow) {
        this.follow(masterToFollow, FollowerType.PercentOutput);
    }

    @Override
    public void valueUpdated() {
    }

    public SensorCollection getSensorCollection() {
        return this._sensorColl;
    }
}

