/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix.motorcontrol;

import com.ctre.phoenix.ErrorCode;
import com.ctre.phoenix.motorcontrol.can.BaseMotorController;
import com.ctre.phoenix.motorcontrol.can.MotControllerJNI;

public class SensorCollection {
    private long _handle;

    public SensorCollection(BaseMotorController motorController) {
        this._handle = motorController.getHandle();
    }

    public int getAnalogIn() {
        return MotControllerJNI.GetAnalogIn(this._handle);
    }

    public ErrorCode setAnalogPosition(int newPosition, int timeoutMs) {
        int retval = MotControllerJNI.SetAnalogPosition(this._handle, newPosition, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getAnalogInRaw() {
        return MotControllerJNI.GetAnalogInRaw(this._handle);
    }

    public int getAnalogInVel() {
        return MotControllerJNI.GetAnalogInVel(this._handle);
    }

    public int getQuadraturePosition() {
        return MotControllerJNI.GetQuadraturePosition(this._handle);
    }

    public ErrorCode setQuadraturePosition(int newPosition, int timeoutMs) {
        int retval = MotControllerJNI.SetQuadraturePosition(this._handle, newPosition, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getQuadratureVelocity() {
        return MotControllerJNI.GetQuadratureVelocity(this._handle);
    }

    public int getPulseWidthPosition() {
        return MotControllerJNI.GetPulseWidthPosition(this._handle);
    }

    public ErrorCode setPulseWidthPosition(int newPosition, int timeoutMs) {
        int retval = MotControllerJNI.SetPulseWidthPosition(this._handle, newPosition, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getPulseWidthVelocity() {
        return MotControllerJNI.GetPulseWidthVelocity(this._handle);
    }

    public int getPulseWidthRiseToFallUs() {
        return MotControllerJNI.GetPulseWidthRiseToFallUs(this._handle);
    }

    public int getPulseWidthRiseToRiseUs() {
        return MotControllerJNI.GetPulseWidthRiseToRiseUs(this._handle);
    }

    public boolean getPinStateQuadA() {
        return MotControllerJNI.GetPinStateQuadA(this._handle) != 0;
    }

    public boolean getPinStateQuadB() {
        return MotControllerJNI.GetPinStateQuadB(this._handle) != 0;
    }

    public boolean getPinStateQuadIdx() {
        return MotControllerJNI.GetPinStateQuadIdx(this._handle) != 0;
    }

    public boolean isFwdLimitSwitchClosed() {
        return MotControllerJNI.IsFwdLimitSwitchClosed(this._handle) != 0;
    }

    public boolean isRevLimitSwitchClosed() {
        return MotControllerJNI.IsRevLimitSwitchClosed(this._handle) != 0;
    }
}

