/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix;

import java.util.HashMap;

public enum ErrorCode {
    OK(0),
    CAN_MSG_STALE(1),
    CAN_TX_FULL(-1),
    TxFailed(-1),
    InvalidParamValue(-2),
    CAN_INVALID_PARAM(-2),
    RxTimeout(-3),
    CAN_MSG_NOT_FOUND(-3),
    TxTimeout(-4),
    CAN_NO_MORE_TX_JOBS(-4),
    UnexpectedArbId(-5),
    CAN_NO_SESSIONS_AVAIL(-5),
    BufferFull(6),
    CAN_OVERFLOW(-6),
    SensorNotPresent(-7),
    FirmwareTooOld(-8),
    GeneralError(-100),
    GENERAL_ERROR(-100),
    SIG_NOT_UPDATED(-200),
    SigNotUpdated(-200),
    NotAllPIDValuesUpdated(-201),
    GEN_PORT_ERROR(-300),
    PORT_MODULE_TYPE_MISMATCH(-301),
    GEN_MODULE_ERROR(-400),
    MODULE_NOT_INIT_SET_ERROR(-401),
    MODULE_NOT_INIT_GET_ERROR(-402),
    WheelRadiusTooSmall(-500),
    TicksPerRevZero(-501),
    DistanceBetweenWheelsTooSmall(-502),
    GainsAreNotSet(-503),
    IncompatibleMode(-600),
    InvalidHandle(-601),
    PulseWidthSensorNotPresent(10),
    GeneralWarning(100),
    FeatureNotSupported(101),
    NotImplemented(102),
    FirmVersionCouldNotBeRetrieved(103),
    FeaturesNotAvailableYet(104),
    ControlModeNotValid(105),
    ControlModeNotSupportedYet(106),
    CascadedPIDNotSupportedYet(107),
    AuxiliaryPIDNotSupportedYet(107),
    RemoteSensorsNotSupportedYet(108),
    MotProfFirmThreshold(109),
    MotProfFirmThreshold2(110);

    public final int value;
    private static HashMap<Integer, ErrorCode> _map;

    private ErrorCode(int initValue) {
        this.value = initValue;
    }

    public static ErrorCode valueOf(int value) {
        ErrorCode retval = _map.get(value);
        if (retval != null) {
            return retval;
        }
        return GeneralError;
    }

    public static ErrorCode worstOne(ErrorCode errorCode1, ErrorCode errorCode2) {
        if (errorCode1.value != 0) {
            return errorCode1;
        }
        return errorCode2;
    }

    public static ErrorCode worstOne(ErrorCode errorCode1, ErrorCode errorCode2, ErrorCode errorCode3) {
        if (errorCode1.value != 0) {
            return errorCode1;
        }
        if (errorCode2.value != 0) {
            return errorCode2;
        }
        return errorCode3;
    }

    public static ErrorCode worstOne(ErrorCode errorCode1, ErrorCode errorCode2, ErrorCode errorCode3, ErrorCode errorCode4) {
        if (errorCode1.value != 0) {
            return errorCode1;
        }
        if (errorCode2.value != 0) {
            return errorCode2;
        }
        if (errorCode3.value != 0) {
            return errorCode3;
        }
        return errorCode4;
    }

    static {
        _map = null;
        _map = new HashMap();
        for (ErrorCode type : ErrorCode.values()) {
            _map.put(type.value, type);
        }
    }
}

