/*
 * Decompiled with CFR 0.152.
 */
package com.ctre.phoenix;

import com.ctre.phoenix.CANifierControlFrame;
import com.ctre.phoenix.CANifierFaults;
import com.ctre.phoenix.CANifierJNI;
import com.ctre.phoenix.CANifierStatusFrame;
import com.ctre.phoenix.CANifierStickyFaults;
import com.ctre.phoenix.ErrorCode;
import com.ctre.phoenix.ParamEnum;
import edu.wpi.first.wpilibj.hal.HAL;

public class CANifier {
    private long m_handle;
    public final int PWMChannelCount = 4;
    private boolean[] _tempPins = new boolean[11];
    private int m_deviceNumber;

    public CANifier(int deviceId) {
        this.m_handle = CANifierJNI.JNI_new_CANifier(deviceId);
        this.m_deviceNumber = deviceId;
        HAL.report((int)63, (int)(deviceId + 1));
    }

    public void setLEDOutput(double percentOutput, LEDChannel ledChannel) {
        if (percentOutput > 1.0) {
            percentOutput = 1.0;
        }
        if (percentOutput < 0.0) {
            percentOutput = 0.0;
        }
        int dutyCycle = (int)(percentOutput * 1023.0);
        CANifierJNI.JNI_SetLEDOutput(this.m_handle, dutyCycle, ledChannel.value);
    }

    public void setGeneralOutput(GeneralPin outputPin, boolean outputValue, boolean outputEnable) {
        CANifierJNI.JNI_SetGeneralOutput(this.m_handle, outputPin.value, outputValue, outputEnable);
    }

    public void setGeneralOutputs(int outputBits, int isOutputBits) {
        CANifierJNI.JNI_SetGeneralOutputs(this.m_handle, outputBits, isOutputBits);
    }

    public void getGeneralInputs(PinValues allPins) {
        CANifierJNI.JNI_GetGeneralInputs(this.m_handle, this._tempPins);
        allPins.LIMF = this._tempPins[GeneralPin.LIMF.value];
        allPins.LIMR = this._tempPins[GeneralPin.LIMR.value];
        allPins.QUAD_A = this._tempPins[GeneralPin.QUAD_A.value];
        allPins.QUAD_B = this._tempPins[GeneralPin.QUAD_B.value];
        allPins.QUAD_IDX = this._tempPins[GeneralPin.QUAD_IDX.value];
        allPins.SCL = this._tempPins[GeneralPin.SCL.value];
        allPins.SDA = this._tempPins[GeneralPin.SDA.value];
        allPins.SPI_CLK_PWM0 = this._tempPins[GeneralPin.SPI_CLK_PWM0P.value];
        allPins.SPI_MOSI_PWM1 = this._tempPins[GeneralPin.SPI_MOSI_PWM1P.value];
        allPins.SPI_MISO_PWM2 = this._tempPins[GeneralPin.SPI_MISO_PWM2P.value];
        allPins.SPI_CS_PWM3 = this._tempPins[GeneralPin.SPI_CS.value];
    }

    public boolean getGeneralInput(GeneralPin inputPin) {
        return CANifierJNI.JNI_GetGeneralInput(this.m_handle, inputPin.value);
    }

    public ErrorCode getLastError() {
        int retval = CANifierJNI.JNI_GetLastError(this.m_handle);
        return ErrorCode.valueOf(retval);
    }

    public void setPWMOutput(int pwmChannel, double dutyCycle) {
        if (dutyCycle < 0.0) {
            dutyCycle = 0.0;
        } else if (dutyCycle > 1.0) {
            dutyCycle = 1.0;
        }
        if (pwmChannel < 0) {
            pwmChannel = 0;
        }
        int dutyCyc10bit = (int)(1023.0 * dutyCycle);
        CANifierJNI.JNI_SetPWMOutput(this.m_handle, pwmChannel, dutyCyc10bit);
    }

    public void enablePWMOutput(int pwmChannel, boolean bEnable) {
        if (pwmChannel < 0) {
            pwmChannel = 0;
        }
        CANifierJNI.JNI_EnablePWMOutput(this.m_handle, pwmChannel, bEnable);
    }

    public void getPWMInput(PWMChannel pwmChannel, double[] dutyCycleAndPeriod) {
        CANifierJNI.JNI_GetPWMInput(this.m_handle, pwmChannel.value, dutyCycleAndPeriod);
    }

    public int getQuadraturePosition() {
        return CANifierJNI.JNI_GetQuadraturePosition(this.m_handle);
    }

    public ErrorCode setQuadraturePosition(int newPosition, int timeoutMs) {
        return ErrorCode.valueOf(CANifierJNI.JNI_SetQuadraturePosition(this.m_handle, newPosition, timeoutMs));
    }

    public int getQuadratureVelocity() {
        return CANifierJNI.JNI_GetQuadratureVelocity(this.m_handle);
    }

    public ErrorCode configVelocityMeasurementPeriod(VelocityPeriod period, int timeoutMs) {
        int retval = CANifierJNI.JNI_ConfigVelocityMeasurementPeriod(this.m_handle, period.value, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configVelocityMeasurementWindow(int windowSize, int timeoutMs) {
        int retval = CANifierJNI.JNI_ConfigVelocityMeasurementWindow(this.m_handle, windowSize, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode configSetCustomParam(int newValue, int paramIndex, int timeoutMs) {
        int retval = CANifierJNI.JNI_ConfigSetCustomParam(this.m_handle, newValue, paramIndex, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int configGetCustomParam(int paramIndex, int timoutMs) {
        int retval = CANifierJNI.JNI_ConfigGetCustomParam(this.m_handle, paramIndex, timoutMs);
        return retval;
    }

    public ErrorCode configSetParameter(ParamEnum param, double value, int subValue, int ordinal, int timeoutMs) {
        return this.configSetParameter(param.value, value, subValue, ordinal, timeoutMs);
    }

    public ErrorCode configSetParameter(int param, double value, int subValue, int ordinal, int timeoutMs) {
        int retval = CANifierJNI.JNI_ConfigSetParameter(this.m_handle, param, value, subValue, ordinal, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public double configGetParameter(ParamEnum param, int ordinal, int timeoutMs) {
        return CANifierJNI.JNI_ConfigGetParameter(this.m_handle, param.value, ordinal, timeoutMs);
    }

    public ErrorCode setStatusFramePeriod(CANifierStatusFrame statusFrame, int periodMs, int timeoutMs) {
        int retval = CANifierJNI.JNI_SetStatusFramePeriod(this.m_handle, statusFrame.value, periodMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setStatusFramePeriod(int statusFrame, int periodMs, int timeoutMs) {
        int retval = CANifierJNI.JNI_SetStatusFramePeriod(this.m_handle, statusFrame, periodMs, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public int getStatusFramePeriod(CANifierStatusFrame frame, int timeoutMs) {
        return CANifierJNI.JNI_GetStatusFramePeriod(this.m_handle, frame.value, timeoutMs);
    }

    public ErrorCode setControlFramePeriod(CANifierControlFrame frame, int periodMs) {
        int retval = CANifierJNI.JNI_SetControlFramePeriod(this.m_handle, frame.value, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public ErrorCode setControlFramePeriod(int frame, int periodMs) {
        int retval = CANifierJNI.JNI_SetControlFramePeriod(this.m_handle, frame, periodMs);
        return ErrorCode.valueOf(retval);
    }

    public int getFirmwareVersion() {
        return CANifierJNI.JNI_GetFirmwareVersion(this.m_handle);
    }

    public boolean hasResetOccurred() {
        return CANifierJNI.JNI_HasResetOccurred(this.m_handle);
    }

    public ErrorCode getFaults(CANifierFaults toFill) {
        int bits = CANifierJNI.JNI_GetFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    public ErrorCode getStickyFaults(CANifierStickyFaults toFill) {
        int bits = CANifierJNI.JNI_GetStickyFaults(this.m_handle);
        toFill.update(bits);
        return this.getLastError();
    }

    public ErrorCode clearStickyFaults(int timeoutMs) {
        int retval = CANifierJNI.JNI_ClearStickyFaults(this.m_handle, timeoutMs);
        return ErrorCode.valueOf(retval);
    }

    public double getBusVoltage() {
        return CANifierJNI.JNI_GetBusVoltage(this.m_handle);
    }

    public int getDeviceID() {
        return this.m_deviceNumber;
    }

    public static class PinValues {
        public boolean QUAD_IDX;
        public boolean QUAD_B;
        public boolean QUAD_A;
        public boolean LIMR;
        public boolean LIMF;
        public boolean SDA;
        public boolean SCL;
        public boolean SPI_CS_PWM3;
        public boolean SPI_MISO_PWM2;
        public boolean SPI_MOSI_PWM1;
        public boolean SPI_CLK_PWM0;
    }

    public static enum GeneralPin {
        QUAD_IDX(CANifierJNI.GeneralPin.QUAD_IDX.value),
        QUAD_B(CANifierJNI.GeneralPin.QUAD_B.value),
        QUAD_A(CANifierJNI.GeneralPin.QUAD_A.value),
        LIMR(CANifierJNI.GeneralPin.LIMR.value),
        LIMF(CANifierJNI.GeneralPin.LIMF.value),
        SDA(CANifierJNI.GeneralPin.SDA.value),
        SCL(CANifierJNI.GeneralPin.SCL.value),
        SPI_CS(CANifierJNI.GeneralPin.SPI_CS.value),
        SPI_MISO_PWM2P(CANifierJNI.GeneralPin.SPI_MISO_PWM2P.value),
        SPI_MOSI_PWM1P(CANifierJNI.GeneralPin.SPI_MOSI_PWM1P.value),
        SPI_CLK_PWM0P(CANifierJNI.GeneralPin.SPI_CLK_PWM0P.value);

        public final int value;

        public static GeneralPin valueOf(int value) {
            for (GeneralPin mode : GeneralPin.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private GeneralPin(int initValue) {
            this.value = initValue;
        }
    }

    public static enum PWMChannel {
        PWMChannel0(0),
        PWMChannel1(1),
        PWMChannel2(2),
        PWMChannel3(3);

        public final int value;

        public static PWMChannel valueOf(int value) {
            for (PWMChannel mode : PWMChannel.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private PWMChannel(int initValue) {
            this.value = initValue;
        }
    }

    public static enum LEDChannel {
        LEDChannelA(0),
        LEDChannelB(1),
        LEDChannelC(2);

        public final int value;

        public static LEDChannel valueOf(int value) {
            for (LEDChannel mode : LEDChannel.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private LEDChannel(int initValue) {
            this.value = initValue;
        }
    }

    public static enum VelocityPeriod {
        Period_1Ms(1),
        Period_2Ms(2),
        Period_5Ms(5),
        Period_10Ms(10),
        Period_20Ms(20),
        Period_25Ms(25),
        Period_50Ms(50),
        Period_100Ms(100);

        public final int value;

        public static VelocityPeriod valueOf(int value) {
            for (VelocityPeriod period : VelocityPeriod.values()) {
                if (period.value != value) continue;
                return period;
            }
            return null;
        }

        private VelocityPeriod(int initValue) {
            this.value = initValue;
        }
    }
}

