/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpiutil;

import java.io.File;

public class RuntimeDetector {
    private static String filePrefix;
    private static String fileExtension;
    private static String filePath;

    private static synchronized void computePlatform() {
        if (fileExtension != null && filePath != null && filePrefix != null) {
            return;
        }
        boolean intel32 = RuntimeDetector.is32BitIntel();
        boolean intel64 = RuntimeDetector.is64BitIntel();
        if (RuntimeDetector.isWindows()) {
            filePrefix = "";
            fileExtension = ".dll";
            filePath = intel32 ? "/windows/x86/" : "/windows/x86-64/";
        } else if (RuntimeDetector.isMac()) {
            filePrefix = "lib";
            fileExtension = ".dylib";
            filePath = intel32 ? "/osx/x86" : "/osx/x86-64/";
        } else if (RuntimeDetector.isLinux()) {
            filePrefix = "lib";
            fileExtension = ".so";
            filePath = intel32 ? "/linux/x86/" : (intel64 ? "/linux/x86-64/" : (RuntimeDetector.isAthena() ? "/linux/athena/" : "/linux/nativearm/"));
        } else {
            throw new RuntimeException("Failed to determine OS");
        }
    }

    public static synchronized String getFilePrefix() {
        RuntimeDetector.computePlatform();
        return filePrefix;
    }

    public static synchronized String getFileExtension() {
        RuntimeDetector.computePlatform();
        return fileExtension;
    }

    public static synchronized String getPlatformPath() {
        RuntimeDetector.computePlatform();
        return filePath;
    }

    public static synchronized String getLibraryResource(String libName) {
        RuntimeDetector.computePlatform();
        return filePath + filePrefix + libName + fileExtension;
    }

    public static boolean isAthena() {
        File runRobotFile = new File("/usr/local/frc/bin/frcRunRobot.sh");
        return runRobotFile.exists();
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean is32BitIntel() {
        String arch = System.getProperty("os.arch");
        return arch.equals("x86") || arch.equals("i386");
    }

    public static boolean is64BitIntel() {
        String arch = System.getProperty("os.arch");
        return arch.equals("amd64") || arch.equals("x86_64");
    }
}

